#include "ninox.h"

static double scan_area(struct Image *,int,int,int,int);
static void scale_area(struct Image *,int,int,int,int,double);

// Scan the image looking for a Bayer pattern in the grey values. If found then it means that
// our camera is looking through a bayer mask and we must boost the luminosity of the red and 
// blue pixels to match the green.

int
DeBayer(struct Image *img)
	{
	int sx,sy,ey,ex;
	double s1,s2,s3,s4,m;
	double f;

	/* calculate a box to scan */
	sx = 1; sy = 1;
	ex = img->width-2; ey = img->height-2;

	/* Scan diagonal area and calculate average luminosity */

	m=0;
	s1 = scan_area(img,sx,sy,ex,ey); if (s1>m) m=s1;
	s2 = scan_area(img,sx,sy+1,ex,ey+1); if (s2>m) m=s2;
	s3 = scan_area(img,sx+1,sy+1,ex+1,ey+1); if (s3>m) m=s3;
	s4 = scan_area(img,sx+1,sy,ex+1,ey); if (s4>m) m=s4;

	// printf("lum %lf %lf %lf %lf\n",s1,s2,s3,s4);

	f = BayerBoost;
	if (m-s1 > 0.1) scale_area(img,sx,sy,ex,ey,m/s1 * f);
	if (m-s2 > 0.1) scale_area(img,sx,sy+1,ex,ey+1,m/s2 * f);
	if (m-s3 > 0.1) scale_area(img,sx+1,sy+1,ex+1,ey+1,m/s3 * f);
	if (m-s4 > 0.1) scale_area(img,sx+1,sy,ex+1,ey,m/s4 * f);

	return 1;
	}

static
double scan_area(
	struct Image *img,
	int x1, int y1, // top left corner of sample region
	int x2, int y2	// bottom right corner of sample region
	)
	{
	unsigned char *buffer = img->data;
	double lum=0;
	int count=0;
	int x,y;
	int o;

	if (img->depth==24) {
	   for(y=y1; y<=y2; y+=2) {
	      o = (y * img->width + x1) * 3;
	      for(x=x1; x<=x2; x+=2,o+=6) {
		if (buffer[o] > ThreshHold) {
	   	   lum += buffer[o]; // This is wrong, should compute luminance
		   count++;
		   }
		}
	      }
	   }
	else if (img->depth==8) {
	   for(y=y1; y<=y2; y+=2) {
	      o = y * img->width + x1;
	      for(x=x1; x<=x2; x+=2,o+=2) {
		if (buffer[o] > ThreshHold) {
	   	   lum += buffer[o];
		   count++;
		   }
		}
	      }
	   }
	else {
	   Print("scan_area: depth %d not supported\n");
	   return 0;
	   }

	if (count==0) {
	   Print("oops - divide by zero in scan_area\n");
	   fflush(stderr); return 0;
	   }

	return lum / (double) count;
	}

static void
scale_area(
	struct Image *img,
	int x1, int y1, // top left corner of sample region
	int x2, int y2,	// bottom right corner of sample region
	double s	// scale factor
	)
	{
	unsigned char *buffer = img->data;
	int x,y;
	int o;
	double v;

	if (img->depth == 24) {
	   for(y=y1; y<=y2; y+=2) {
	      o = (y * img->width + x1) * 3;
	      for(x=x1; x<=x2; x+=2,o+=6) {
		v = buffer[o];
		v *= s;  if (v>255) v=255; if (v<0) v=0;
	   	buffer[o] = (int)v;  // Wrong, should scale according to luminance
	   	buffer[o+1] = (int)v;
	   	buffer[o+2] = (int)v;
		}
	      }
	   }
	else if (img->depth==8) {
	   for(y=y1; y<=y2; y+=2) {
	      o = y * img->width + x1;
	      for(x=x1; x<=x2; x+=2,o+=2) {
		v = buffer[o];
		v *= s;  if (v>255) v=255; if (v<0) v=0;
	   	buffer[o] = (int)v;  // Wrong, should scale according to luminance
		}
	      }
	   }

	}
