/* THIS FILE IS AUTO-GENERATED, DO NOT EDIT */

#define VALUE_B (bval)
#define VALUE_S (val)
#define VALUE_I atoi(val)
#define VALUE_F atof(val)
#define BOOLEAN(x) ((x)=(bval==1?1:0))
#define RETURN return(1)
#define FAIL return(-1)

#include "ninox.h"

int _CMD_amean(char *arg, char *val, int bval)
	{
	BOOLEAN(AMean);
	return(1);
	}

int _HLP__CMD_amean(char *arg, char *val, int bval)
	{
	Print("\nHelp for '%s'\n\n","amean");
	Print("	Enable the alpha-trimmed-mean smoothing algorithm\n");
	exit(0);
	}

int _CMD_archiveoverridefilenames(char *arg, char *val, int bval)
	{
	BOOLEAN(ArchiveOverrideFilenames);
	return(1);
	}

int _HLP__CMD_archiveoverridefilenames(char *arg, char *val, int bval)
	{
	Print("\nHelp for '%s'\n\n","archiveoverridefilenames");
	Print("	no help available\n");
	exit(0);
	}

int _CMD_bayer8(char *arg, char *val, int bval)
	{
	BOOLEAN(Bayer8);
	return(1);
	}

int _CMD_bayerboost(char *arg, char *val, int bval)
	{
	BayerBoost = VALUE_F;
	if (BayerBoost == 0) BayerBoost = 1.0;
	return(1);
	}

int _CMD_chain(char *arg, char *val, int bval)
	{
	BOOLEAN(ChainArchives);
	return(1);
	}

int _HLP__CMD_chain(char *arg, char *val, int bval)
	{
	Print("\nHelp for '%s'\n\n","chain");
	Print("	When playing or processing FITS Archive files (.fta), automatically\n");
	Print("	chain from the end of one archive to the start of the next\n");
	exit(0);
	}

int _CMD_count(char *arg, char *val, int bval)
	{
	// How many images to process
	ImageCount=VALUE_I;
	return(1);
	}

int _CMD_cut(char *arg, char *val, int bval)
	{
	int x,y;
	if (sscanf(VALUE_S,"%d,%d",&x,&y)==2) {
		CutX = x;
		CutY = y;
		}
	else {
	   if (VALUE_I < 100 || VALUE_I>1000) {
		Print("%d: Outside valid bounds 100..1000\n",VALUE_I);
		FAIL;
		}
	   CutX = VALUE_I; CutY = VALUE_I;
	   newWidth = CutX;
	   newHeight = CutY;
	   }
	return(1);
	}

int _CMD_cutx(char *arg, char *val, int bval)
	{
	CutX = VALUE_I;
	if (CutX < 100) {
	   Print("-cutx: minimum supported size 100 pixels\n");
	   FAIL;
	   }
	return(1);
	}

int _CMD_cuty(char *arg, char *val, int bval)
	{
	CutY = VALUE_I;
	if (CutY < 100) {
	   Print("-cutx: minimum supported size 100 pixels\n");
	   FAIL;
	   }
	return(1);
	}

int _CMD_darkframe(char *arg, char *val, int bval)
	{
	double scale;
	char fname[512];
	if (sscanf(VALUE_S,"%lf,%s",&scale,fname) == 2) {
		DarkFrame = strdup(fname);
		DarkFrame_Scale = scale;
		}
	else {
		DarkFrame = strdup(VALUE_S);
		DarkFrame_Scale = 1.0;
		}
	return(1);
	}

int _CMD_dbf_diff(char *arg, char *val, int bval)
	{
	DBF_DIFF = VALUE_I;
	return(1);
	}

int _CMD_dbfedgecount(char *arg, char *val, int bval)
	{
	DBF_EDGE_COUNT = VALUE_I;
	return(1);
	}

int _HLP__CMD_dbfedgecount(char *arg, char *val, int bval)
	{
	Print("\nHelp for '%s'\n\n","dbfedgecount");
	Print("	With detectbrokenframes, this sets a threshhold for detecting\n");
	Print("	broken frames.\n");
	exit(0);
	}

int _CMD_debayer(char *arg, char *val, int bval)
	{
	DoDeBayer = VALUE_I;
	return(1);
	}

int _CMD_debug(char *arg, char *val, int bval)
	{
	BOOLEAN(DEBUG);
	return(1);
	}

int _CMD_detectbrokenframes(char *arg, char *val, int bval)
	{
	if (!strcasecmp(VALUE_S,"planet")) DBF_TYPE = DBF_PLANET;
	else if (!strcasecmp(VALUE_S,"lunar")) DBF_TYPE = DBF_LUNAR;
	else if (!strcasecmp(VALUE_S,"moon")) DBF_TYPE = DBF_LUNAR;
	DetectBrokenFrames = 1;
	return(1);
	}

int _HLP__CMD_detectbrokenframes(char *arg, char *val, int bval)
	{
	Print("\nHelp for '%s'\n\n","detectbrokenframes");
	Print("	ninox will use an algorithm to detect corrupted (broken) frames\n");
	Print("	by comparing each frame to its predecessor. Sudden large-scale\n");
	Print("	changes are interpreted as corruption and the frame is skipped.\n");
	exit(0);
	}

int _CMD_detecthotpixels(char *arg, char *val, int bval)
	{
	BOOLEAN(DetectHotPixels);
	return(1);
	}

int _CMD_display(char *arg, char *val, int bval)
	{
	DisplayFrames = 1;
	if (! strcasecmp(VALUE_S,"pause")) DisplayPause=1;
	return(1);
	}

int _CMD_dofft(char *arg, char *val, int bval)
	{
	BOOLEAN(DoFFT);
	return(1);
	}

int _CMD_enablecutout(char *arg, char *val, int bval)
	{
	BOOLEAN(DoCutout);
	if (! VALUE_B) ForceProcess=1;
	return(1);
	}

int _HLP__CMD_enablecutout(char *arg, char *val, int bval)
	{
	Print("\nHelp for '%s'\n\n","enablecutout");
	Print("	ninox will attempt to locate and centre the dominant object in the\n");
	Print("	frame by finding the centre of brightness and \"cutting out\" a rectangle\n");
	Print("	around that point and moving it to the centre of the image.\n");
	exit(0);
	}

int _CMD_forceprocess(char *arg, char *val, int bval)
	{
	BOOLEAN(ForceProcess);
	return(1);
	}

int _CMD_gain(char *arg, char *val, int bval)
	{
	Gain = VALUE_F;
	if (Gain != 1.0) ChangeGain = 1;
	return(1);
	}

int _CMD_gaincomp(char *arg, char *val, int bval)
	{
         BOOLEAN(ApplyGainComp);
         if (ApplyGainComp && ! LoadGainCompRef(VALUE_S)) {
               Print("Error loading gain compensation reference\n");
               FAIL;
               }
	return(1);
	}

int _CMD_gamma(char *arg, char *val, int bval)
	{
	double g = VALUE_F;
	if (g < 0.3 || g > 1.5) {
	   Print("Gamma value %f is outside accepted range 0.3 <= gamma <= 1.5\n",g);
	   FAIL;
	   }
	Gamma = g;
	if (Gamma != 1.0) ChangeGamma = 1;
	return(1);
	}

int _CMD_height(char *arg, char *val, int bval)
	{
	newHeight = VALUE_I;
	if (newHeight < 100 || newHeight > 1000) {
	   Print("Height must be 100..1000\n");
	   FAIL;
	   }
	return(1);
	}

int _CMD_help(char *arg, char *val, int bval)
	{
	int i;
	Print("\nUsage: ninox [ switches] [files or directories]\n\n");
	Print("Switches: \n\n");
	for(i=0; Names[i].func != NULL; ++i)
	   if (! strstr(Names[i].option,"help-"))
		Print("-%s ",Names[i].option);
	Print("\n\n");
	Print("Use \"ninox -help-X\" to see detailed help about switch X\n\n");
	exit(0);
	
	return(1);
	}

int _CMD_hnoisefilter(char *arg, char *val, int bval)
	{
	BOOLEAN(HNoiseFilter);
	return(1);
	}

int _CMD_i(char *arg, char *val, int bval)
	{
	BOOLEAN(InteractiveMode);
	return(1);
	}

int _HLP__CMD_i(char *arg, char *val, int bval)
	{
	Print("\nHelp for '%s'\n\n","i");
	Print("	Enter interactive mode\n");
	exit(0);
	}

int _CMD_inputfilter(char *arg, char *val, int bval)
	{
	if (InputFilter==0 && VALUE_F > 0) InputFilter_ThreshHold = VALUE_F;
	++InputFilter;
	return(1);
	}

int _HLP__CMD_inputfilter(char *arg, char *val, int bval)
	{
	Print("\nHelp for '%s'\n\n","inputfilter");
	Print("	Enables an input filter algorithm which replaces pixels that are too bright/dark\n");
	Print("	when compared to their neighbors. favours dark pixels.\n");
	exit(0);
	}

int _CMD_invert(char *arg, char *val, int bval)
	{
	BOOLEAN(doInvertImage);
	return(1);
	}

int _CMD_istretch(char *arg, char *val, int bval)
	{
	BOOLEAN(InputHistoStretch);
	return(1);
	}

int _CMD_levels(char *arg, char *val, int bval)
	{
	int min,max;
	if (sscanf(val,"%d,%d",&min,&max) != 2) {
	   printf("syntax error on 'levels'\n");
	   FAIL;
	   }
	LevelsMin = min;
	LevelsMax = max;
	doLevelsAdjust = 1;
	return(1);
	}

int _CMD_mean3(char *arg, char *val, int bval)
	{
	BOOLEAN(Do3x3Smooth);
	return(1);
	}

int _HLP__CMD_mean3(char *arg, char *val, int bval)
	{
	Print("\nHelp for '%s'\n\n","mean3");
	Print("	Enable a 3x3 mean smoothing on the image\n");
	exit(0);
	}

int _CMD_mergefile(char *arg, char *val, int bval)
	{
	MergeFile = strdup(VALUE_S);
	return(1);
	}

int _CMD_mergethreshhold(char *arg, char *val, int bval)
	{
	MergeThreshHold = VALUE_F;
	return(1);
	}

int _CMD_minpixels(char *arg, char *val, int bval)
	{
	MinPixels = VALUE_I;
	if (MinPixels<10 || MinPixels > 1000) {
	   Print("Minpixels: %d out of alloed range 10..1000\n",MinPixels);
	   FAIL;
	   }
	return(1);
	}

int _CMD_morph_across(char *arg, char *val, int bval)
	{
	// Number of control points across the image
	Morph_Across = VALUE_I;
	return(1);
	}

int _CMD_morph_de(char *arg, char *val, int bval)
	{
	// Enable extra debugging
	Morph_Debug = VALUE_I;
	return(1);
	}

int _CMD_morph_down(char *arg, char *val, int bval)
	{
	// Number of control points down the image
	Morph_Down = VALUE_I;
	
	return(1);
	}

int _CMD_morph_dr(char *arg, char *val, int bval)
	{
	Morph_Drift = VALUE_I;
	return(1);
	}

int _CMD_morph_it(char *arg, char *val, int bval)
	{
	// Number of morph iterations to run
	Morph_Iterations = VALUE_I;
	return(1);
	}

int _CMD_morph_max_translate(char *arg, char *val, int bval)
	{
	Morph_MaxTranslate = VALUE_I;
	return(1);
	}

int _CMD_morph_min_divisor(char *arg, char *val, int bval)
	{
	Morph_Min_Divisor = VALUE_I;
	
	return(1);
	}

int _CMD_morph_ref(char *arg, char *val, int bval)
	{
	Morph_Ref = strdup(VALUE_S);
	if (access(Morph_Ref,0)) {
	   Print("morph_ref: Reference image '%s' does not exist\n",val);
	   FAIL;
	   }
	return(1);
	}

int _CMD_morphing(char *arg, char *val, int bval)
	{
	Morphing = atoi(val);
	return(1);
	}

int _CMD_nocutout(char *arg, char *val, int bval)
	{
	DoCutout=0;
	ForceProcess = 1;
	return(1);
	}

int _CMD_nosave(char *arg, char *val, int bval)
	{
	BOOLEAN(NoSave);
	return(1);
	}

int _CMD_outdir(char *arg, char *val, int bval)
	{
	int i;
	OutDir = strdup(VALUE_S);
	for(i=0; OutDir[i]; ++i) if (OutDir[i]=='\\') OutDir[i]='/';
	return(1);
	}

int _CMD_output_depth(char *arg, char *val, int bval)
	{
	OutputFileDepth = VALUE_I;
	return(1);
	}

int _CMD_output_type(char *arg, char *val, int bval)
	{
	if (!strcasecmp(VALUE_S,"bmp")) 	OutputFileType = IMG_BMP;
	else if (!strncasecmp(VALUE_S,"fit",3)) OutputFileType = IMG_FIT;
	else if (!strcasecmp(VALUE_S,"ppm")) 	OutputFileType = IMG_PPM;
	else {
	   Print("output file type '%s' not understood\n",VALUE_S);
	   FAIL;
	   }
	return(1);
	}

int _CMD_overwrite(char *arg, char *val, int bval)
	{
	BOOLEAN(AllowOverwrite);
	return(1);
	}

int _CMD_popfilter(char *arg, char *val, int bval)
	{
 	char when[32];
	int sz = 5;
	if (sscanf(VALUE_S,"%d,%s",&sz,when) == 2) {
	   if (!strcasecmp(when,"before")) PopFilter_When = POPFILTER_BEFORE;
	   else if (!strcasecmp(when,"after")) PopFilter_When = POPFILTER_AFTER;
	   else {
		Print("Unknown option '%s' to popfilter\n",when);
		FAIL;
		}
	   if (sz<=0) {
		Print("invalid size arg '%d' to popfilter\n",sz);
		FAIL;
		}
	   PopFilter = sz;
	   }
	else if (! strcasecmp(VALUE_S,"before")) {
		PopFilter_When = POPFILTER_BEFORE;
		PopFilter = 5;
		}
	else if (! strcasecmp(VALUE_S,"after")) {
		PopFilter_When = POPFILTER_AFTER;
		PopFilter = 5;
		}
	else if (VALUE_I > 0) {
		PopFilter = VALUE_I;
		PopFilter_When = POPFILTER_BEFORE;
		}
	else {
		PopFilter = 5;
		PopFilter_When = POPFILTER_BEFORE;
		}
	return(1);
	}

int _CMD_process(char *arg, char *val, int bval)
	{
	// process=Offset,Skip for cooperatively processing a video sequence
	if (sscanf(VALUE_S,"%d,%d",&ProcessOffset,&ProcessSkip) != 2) {
	   printf("process: invalid argument, wanted process=offset,skip\n");
	   FAIL;
	   }
	return(1);
	}

int _HLP__CMD_process(char *arg, char *val, int bval)
	{
	Print("\nHelp for '%s'\n\n","process");
	Print("	Useful on multi-core or multi-processor machines. Allows you to specify\n");
	Print("	a subset of the available images to be processed on the assumption that\n");
	Print("	another invocation of ninox will be processing the skipped images.\n");
	Print("	\n");
	Print("	Usage: -process=offset,skip\n");
	Print("	\n");
	Print("	Offset is the starting image number (0 = first)\n");
	Print("	Skip is the number of images to skip after processing an image (default=0)\n");
	Print("	\n");
	Print("	eg, to run 2 copies of ninox, use:\n");
	Print("	\n");
	Print("	ninox -process=0,1 ...\n");
	Print("	and\n");
	Print("	ninox -process=1,1 ...\n");
	Print("	\n");
	Print("	with all other switches identical. The first invocation here will process\n");
	Print("	images 0,2,4,6,... and the second will process images 1,3,5,7 ...\n");
	exit(0);
	}

int _CMD_protect(char *arg, char *val, int bval)
	{
	BOOLEAN(HistoProtect);
	return(1);
	}

int _CMD_qestimator(char *arg, char *val, int bval)
	{
	int min,max,ch;
	BOOLEAN(QEstimator);
	// Possible value "n,m" representing min and max subsampling
	if (sscanf(val,"%d%c%d",&min,&ch,&max)==3) {
	   QSUBSAMPLE_MIN = min;
	   QSUBSAMPLE_MAX = max;
	   QEstimator = 1;
	   }
	return(1);
	}

int _CMD_qfunc(char *arg, char *val, int bval)
	{
	if (! strncasecmp(VALUE_S,"hist",4)) QualityFunction = HISTO;
	else if (! strncasecmp(VALUE_S,"grad",4)) QualityFunction = GRADIENT; // default
	else {
		printf("Unknown quality function '%s'\n",val);
		FAIL;
		}
	return(1);
	}

int _CMD_qhistfile(char *arg, char *val, int bval)
	{
	   QHISTO_FILE = strdup(VALUE_S);
	return(1);
	}

int _CMD_qhisto(char *arg, char *val, int bval)
	{
	int x1,y1,x2,y2,min,max;
	if (sscanf(val,"%d,%d-%d,%d:%d-%d",&x1,&y1,&x2,&y2,&min,&max)==6)
		QAddRegion(x1,y1,x2,y2,min,max);
	if (sscanf(val,"%d,%d",&min,&max)==2) {
	   	QHISTO_MIN = min;
		QHISTO_MAX = max;
		}
	else {
		printf("Usage: -qhisto=min,max (8 bit values)\n");
		FAIL;
		}
	return(1);
	}

int _CMD_qmargin(char *arg, char *val, int bval)
	{
	   // -qmargin=0.25 for 25% margin on all borders
	   QMargin = VALUE_F;
	return(1);
	}

int _CMD_qtrim(char *arg, char *val, int bval)
	{
	QTrim = VALUE_I;
	return(1);
	}

int _CMD_quiet(char *arg, char *val, int bval)
	{
	Quiet = bval;
	return(1);
	}

int _CMD_qwrite(char *arg, char *val, int bval)
	{
	BOOLEAN(QWriteIntermediateFiles);
	return(1);
	}

int _CMD_renumber(char *arg, char *val, int bval)
	{
	BOOLEAN(QRenumberFiles);
	if (!strcasecmp(VALUE_S,"last")) QRenumberFiles = QRENUMBER_LAST;
	return(1);
	}

int _CMD_rotate(char *arg, char *val, int bval)
	{
	RotateAngle = VALUE_F;
	if (RotateAngle != 0) do_Rotate=1;
	return(1);
	}

int _CMD_rotatecutoff(char *arg, char *val, int bval)
	{
	RotateCutoff = VALUE_I;
	return(1);
	}

int _CMD_runfile(char *arg, char *val, int bval)
	{
	RunFile = strdup(VALUE_S);
	return(1);
	}

int _CMD_scan(char *arg, char *val, int bval)
	{
	// give a non-central place to start scanning for FindCentre()
	int x1,y1;
	char fname[512];
	if (sscanf(VALUE_S,"%d,%d",&x1,&y1) != 2) {
	   printf("-scan: invalid format, should be -scan=x,y\n");
	   FAIL;
	   }
	Sub_x = x1;
	Sub_y = y1;
	return(1);
	}

int _CMD_smoothing(char *arg, char *val, int bval)
	{
	if (!strcasecmp(VALUE_S,"before")) {
	   UpScale_Smoothing_When = SMOOTHING_BEFORE;
	   UpScale_Smoothing = 1;
	   }
	else if (!strcasecmp(VALUE_S,"after")) {
	   UpScale_Smoothing_When = SMOOTHING_AFTER;
	   UpScale_Smoothing = 1;
	   }
	else BOOLEAN(UpScale_Smoothing);
	return(1);
	}

int _CMD_stack(char *arg, char *val, int bval)
	{
	StackFile = strdup(VALUE_S);
	return(1);
	}

int _CMD_stackcount(char *arg, char *val, int bval)
	{
	StackMax = VALUE_I;
	return(1);
	}

int _CMD_status(char *arg, char *val, int bval)
	{
	ShowGlobals();
	exit(1);
	return(1);
	}

int _CMD_streamfilter(char *arg, char *val, int bval)
	{
	StreamFilter = 1;
	if (VALUE_I)
	   StreamFilter_History = VALUE_I;
	return(1);
	}

int _CMD_stretch(char *arg, char *val, int bval)
	{
	HistoStretch = VALUE_I;
	if (HistoStretch==0) HistoStretch = 200;
	return(1);
	}

int _CMD_subdirs(char *arg, char *val, int bval)
	{
	BOOLEAN(SubDirs);
	return(1);
	}

int _CMD_subregion(char *arg, char *val, int bval)
	{
	// subregion specifies a region to be used after the image has been centered
	// and cutout. This subregion replaces the centered image
	int x1,y1,x2,y2;
	char fname[512];
	if (sscanf(val,"%d,%d,%d,%d",&x1,&y1,&x2,&y2) != 4) {
	   printf("-subregion: Invalid format, should be -subregion=x1,y1,x2,y2\n");
	   FAIL;
	   }
	EnableSubRegion = 1;
	SR_X1 = x1;
	SR_X2 = x2;
	SR_Y1 = y1;
	SR_Y2 = y2;
	DoCutout=0;
	return(1);
	}

int _CMD_subsample_max_offset(char *arg, char *val, int bval)
	{
	Subsample_max_offset = VALUE_F;
	return(1);
	}

int _CMD_subsample_min_offset(char *arg, char *val, int bval)
	{
	Subsample_min_offset = VALUE_F;
	return(1);
	}

int _CMD_subsample_nframes(char *arg, char *val, int bval)
	{
	Subsample_nframes = VALUE_I;
	return(1);
	}

int _CMD_subsample_noise(char *arg, char *val, int bval)
	{
	Subsample_noise = VALUE_I;
	return(1);
	}

int _CMD_subsample_pixel_height(char *arg, char *val, int bval)
	{
	Subsample_pixel_height = VALUE_I;
	return(1);
	}

int _CMD_subsample_pixel_size(char *arg, char *val, int bval)
	{
	Subsample_pixel_height = Subsample_pixel_width = VALUE_I;
	return(1);
	}

int _CMD_subsample_pixel_width(char *arg, char *val, int bval)
	{
	Subsample_pixel_width = VALUE_I;
	return(1);
	}

int _CMD_subsample_prefix(char *arg, char *val, int bval)
	{
	Subsample_prefix = strdup(VALUE_S);
	return(1);
	}

int _CMD_subsample_scan(char *arg, char *val, int bval)
	{
	BOOLEAN(Subsample_scan);
	return(1);
	}

int _CMD_subsample_smooth(char *arg, char *val, int bval)
	{
	Subsample_smooth = VALUE_I;
	return(1);
	}

int _CMD_subsample_upscale(char *arg, char *val, int bval)
	{
	Subsample_upscale = VALUE_I;
	return(1);
	}

int _CMD_subsample_xpixels(char *arg, char *val, int bval)
	{
	Subsample_xpixels= VALUE_I;
	return(1);
	}

int _CMD_subsample_ypixels(char *arg, char *val, int bval)
	{
	Subsample_ypixels= VALUE_I;
	return(1);
	}

int _CMD_subsamplemode(char *arg, char *val, int bval)
	{
       SubsampleMode = VALUE_I;
       NoSave = 1;
	return(1);
	}

int _CMD_threshhold(char *arg, char *val, int bval)
	{
	int t = VALUE_I;
	if (t<5 || t > 250) {
	   Print("Threshhold %d out of allowed range 5..250\n",t);
	   FAIL;
	   }
	ThreshHold = t;
	return(1);
	}

int _CMD_upscale(char *arg, char *val, int bval)
	{
	char *ptr = strstr(VALUE_S,"/");
	int up=1,down=1;
	if (ptr) {
	   *ptr = 0;
	   down = atoi(ptr+1);
	   }
	up = VALUE_I;
	if (up < 1 || up > 6 || down<1 || down>6) {
	   Print("UpScale: %d/%d out of accepted range (1..6)/(1..6) \n",up,down);
	   FAIL;
	   }
	UpScale = up;
	DownScale = down;
 	if (UpScale_Smoothing < 0) {
             double scalef = (double)UpScale / (double) DownScale;
             if (scalef <= 2) UpScale_Smoothing = 0;
	     else UpScale_Smoothing = 1;
	     }
	return(1);
	}

int _CMD_white(char *arg, char *val, int bval)
	{
	White = VALUE_I;
	return(1);
	}

int _CMD_width(char *arg, char *val, int bval)
	{
	newWidth = VALUE_I;
	if (newWidth < 100 || newWidth>1000) {
	   Print("Width must be 100..1000\n");
	   FAIL;
	   }
	return(1);
	}

int _CMD_writeemptyfiles(char *arg, char *val, int bval)
	{
	BOOLEAN(forceWriteEmptyFiles);
	BOOLEAN(WriteEmptyFiles);
	return(1);
	}



struct cfunc Names[] = {
	{"amean" , _CMD_amean },
	{"help-amean" , _HLP__CMD_amean },
	{"archiveoverridefilenames" , _CMD_archiveoverridefilenames },
	{"help-archiveoverridefilenames" , _HLP__CMD_archiveoverridefilenames },
	{"bayer8" , _CMD_bayer8 },
	{"bayerboost" , _CMD_bayerboost },
	{"chain" , _CMD_chain },
	{"help-chain" , _HLP__CMD_chain },
	{"count" , _CMD_count },
	{"cut" , _CMD_cut },
	{"cutout" , _CMD_enablecutout },
	{"help-cutout" , _HLP__CMD_enablecutout },
	{"cutx" , _CMD_cutx },
	{"cuty" , _CMD_cuty },
	{"darkframe" , _CMD_darkframe },
	{"dbf" , _CMD_detectbrokenframes },
	{"help-dbf" , _HLP__CMD_detectbrokenframes },
	{"dbf-diff" , _CMD_dbf_diff },
	{"dbfedgecount" , _CMD_dbfedgecount },
	{"help-dbfedgecount" , _HLP__CMD_dbfedgecount },
	{"debayer" , _CMD_debayer },
	{"debug" , _CMD_debug },
	{"detectbrokenframes" , _CMD_detectbrokenframes },
	{"help-detectbrokenframes" , _HLP__CMD_detectbrokenframes },
	{"detecthotpixels" , _CMD_detecthotpixels },
	{"dhp" , _CMD_detecthotpixels },
	{"display" , _CMD_display },
	{"dofft" , _CMD_dofft },
	{"enablecutout" , _CMD_enablecutout },
	{"help-enablecutout" , _HLP__CMD_enablecutout },
	{"forceprocess" , _CMD_forceprocess },
	{"gain" , _CMD_gain },
	{"gaincomp" , _CMD_gaincomp },
	{"gamma" , _CMD_gamma },
	{"height" , _CMD_height },
	{"help" , _CMD_help },
	{"hnoisefilter" , _CMD_hnoisefilter },
	{"i" , _CMD_i },
	{"help-i" , _HLP__CMD_i },
	{"inputfilter" , _CMD_inputfilter },
	{"help-inputfilter" , _HLP__CMD_inputfilter },
	{"invert" , _CMD_invert },
	{"istretch" , _CMD_istretch },
	{"levels" , _CMD_levels },
	{"ma" , _CMD_morph_across },
	{"md" , _CMD_morph_down },
	{"mdbg" , _CMD_morph_de },
	{"mdebug" , _CMD_morph_de },
	{"mean3" , _CMD_mean3 },
	{"help-mean3" , _HLP__CMD_mean3 },
	{"mergefile" , _CMD_mergefile },
	{"mergethreshhold" , _CMD_mergethreshhold },
	{"mi" , _CMD_morph_it },
	{"minpixels" , _CMD_minpixels },
	{"morph-across" , _CMD_morph_across },
	{"morph-de" , _CMD_morph_de },
	{"morph-down" , _CMD_morph_down },
	{"morph-dr" , _CMD_morph_dr },
	{"morph-drift" , _CMD_morph_dr },
	{"morph-it" , _CMD_morph_it },
	{"morph-iterations" , _CMD_morph_it },
	{"morph-max-translate" , _CMD_morph_max_translate },
	{"morph-min-divisor" , _CMD_morph_min_divisor },
	{"morph-ref" , _CMD_morph_ref },
	{"morph_across" , _CMD_morph_across },
	{"morph_debug" , _CMD_morph_de },
	{"morph_down" , _CMD_morph_down },
	{"morph_drift" , _CMD_morph_dr },
	{"morph_it" , _CMD_morph_it },
	{"morph_iterations" , _CMD_morph_it },
	{"morph_max_translate" , _CMD_morph_max_translate },
	{"morph_min_divisor" , _CMD_morph_min_divisor },
	{"morph_ref" , _CMD_morph_ref },
	{"morphing" , _CMD_morphing },
	{"mr" , _CMD_morph_ref },
	{"mx" , _CMD_morph_max_translate },
	{"nocutout" , _CMD_nocutout },
	{"nosave" , _CMD_nosave },
	{"od" , _CMD_output_depth },
	{"oft" , _CMD_output_type },
	{"outdir" , _CMD_outdir },
	{"output-depth" , _CMD_output_depth },
	{"output-type" , _CMD_output_type },
	{"overwrite" , _CMD_overwrite },
	{"popfilter" , _CMD_popfilter },
	{"process" , _CMD_process },
	{"help-process" , _HLP__CMD_process },
	{"protect" , _CMD_protect },
	{"qe" , _CMD_qestimator },
	{"qestimator" , _CMD_qestimator },
	{"qf" , _CMD_qfunc },
	{"qfunc" , _CMD_qfunc },
	{"qhistfile" , _CMD_qhistfile },
	{"qhisto" , _CMD_qhisto },
	{"qmargin" , _CMD_qmargin },
	{"qrenumber" , _CMD_renumber },
	{"qsort" , _CMD_renumber },
	{"qtrim" , _CMD_qtrim },
	{"quiet" , _CMD_quiet },
	{"qwrite" , _CMD_qwrite },
	{"renumber" , _CMD_renumber },
	{"resample" , _CMD_upscale },
	{"rescale" , _CMD_upscale },
	{"rotate" , _CMD_rotate },
	{"rotatecutoff" , _CMD_rotatecutoff },
	{"runfile" , _CMD_runfile },
	{"scan" , _CMD_scan },
	{"smoothing" , _CMD_smoothing },
	{"stack" , _CMD_stack },
	{"stackcount" , _CMD_stackcount },
	{"stackfile" , _CMD_stack },
	{"status" , _CMD_status },
	{"streamfilter" , _CMD_streamfilter },
	{"stretch" , _CMD_stretch },
	{"subdirs" , _CMD_subdirs },
	{"subregion" , _CMD_subregion },
	{"subsample_max_offset" , _CMD_subsample_max_offset },
	{"subsample_min_offset" , _CMD_subsample_min_offset },
	{"subsample_nframes" , _CMD_subsample_nframes },
	{"subsample_noise" , _CMD_subsample_noise },
	{"subsample_pixel_height" , _CMD_subsample_pixel_height },
	{"subsample_pixel_size" , _CMD_subsample_pixel_size },
	{"subsample_pixel_width" , _CMD_subsample_pixel_width },
	{"subsample_prefix" , _CMD_subsample_prefix },
	{"subsample_scan" , _CMD_subsample_scan },
	{"subsample_smooth" , _CMD_subsample_smooth },
	{"subsample_upscale" , _CMD_subsample_upscale },
	{"subsample_xpixels" , _CMD_subsample_xpixels },
	{"subsample_ypixels" , _CMD_subsample_ypixels },
	{"subsamplemode" , _CMD_subsamplemode },
	{"threshhold" , _CMD_threshhold },
	{"upsample" , _CMD_upscale },
	{"upscale" , _CMD_upscale },
	{"white" , _CMD_white },
	{"width" , _CMD_width },
	{"writeemptyfiles" , _CMD_writeemptyfiles },
	{ "", NULL }};

int ShowGlobals()
	{
	Print("%-30.30s: %d\n","AllowOverwrite",AllowOverwrite);
	Print("%-30.30s: %d\n","AMean",AMean);
	Print("%-30.30s: %d\n","ApplyGainComp",ApplyGainComp);
	Print("%-30.30s: %d\n","ArchiveOverrideFilenames",ArchiveOverrideFilenames);
	Print("%-30.30s: %d\n","Bayer8",Bayer8);
	Print("%-30.30s: %lf\n","BayerBoost",BayerBoost);
	Print("%-30.30s: %d\n","ChainArchives",ChainArchives);
	Print("%-30.30s: %d\n","ChangeGain",ChangeGain);
	Print("%-30.30s: %d\n","ChangeGamma",ChangeGamma);
	Print("%-30.30s: %d\n","cur_Sub_x",cur_Sub_x);
	Print("%-30.30s: %d\n","cur_Sub_y",cur_Sub_y);
	Print("%-30.30s: %s\n","CurrentFile",CurrentFile);
	Print("%-30.30s: %d\n","CutX",CutX);
	Print("%-30.30s: %d\n","CutY",CutY);
	Print("%-30.30s: %s\n","DarkFrame",DarkFrame);
	Print("%-30.30s: %lf\n","DarkFrame_Scale",DarkFrame_Scale);
	Print("%-30.30s: %d\n","DBF_DIFF",DBF_DIFF);
	Print("%-30.30s: %d\n","DBF_EDGE_COUNT",DBF_EDGE_COUNT);
	Print("%-30.30s: %d\n","DBF_TYPE",DBF_TYPE);
	Print("%-30.30s: %d\n","DEBUG",DEBUG);
	Print("%-30.30s: %d\n","DetectBrokenFrames",DetectBrokenFrames);
	Print("%-30.30s: %d\n","DetectHotPixels",DetectHotPixels);
	Print("%-30.30s: %d\n","DisplayFrames",DisplayFrames);
	Print("%-30.30s: %d\n","DisplayPause",DisplayPause);
	Print("%-30.30s: %d\n","Do3x3Smooth",Do3x3Smooth);
	Print("%-30.30s: %d\n","do_Rotate",do_Rotate);
	Print("%-30.30s: %d\n","DoCutout",DoCutout);
	Print("%-30.30s: %d\n","DoDeBayer",DoDeBayer);
	Print("%-30.30s: %d\n","DoFFT",DoFFT);
	Print("%-30.30s: %d\n","doInvertImage",doInvertImage);
	Print("%-30.30s: %d\n","doLevelsAdjust",doLevelsAdjust);
	Print("%-30.30s: %d\n","DownScale",DownScale);
	Print("%-30.30s: %d\n","EnableSubRegion",EnableSubRegion);
	Print("%-30.30s: %d\n","ForceProcess",ForceProcess);
	Print("%-30.30s: %d\n","forceWriteEmptyFiles",forceWriteEmptyFiles);
	Print("%-30.30s: %lf\n","Gain",Gain);
	Print("%-30.30s: %lf\n","Gamma",Gamma);
	Print("%-30.30s: %d\n","HaveWindow",HaveWindow);
	Print("%-30.30s: %d\n","HistoProtect",HistoProtect);
	Print("%-30.30s: %d\n","HistoStretch",HistoStretch);
	Print("%-30.30s: %d\n","HNoiseFilter",HNoiseFilter);
	Print("%-30.30s: %d\n","ImageCount",ImageCount);
	Print("%-30.30s: %d\n","InputFilter",InputFilter);
	Print("%-30.30s: %lf\n","InputFilter_ThreshHold",InputFilter_ThreshHold);
	Print("%-30.30s: %d\n","InputHistoStretch",InputHistoStretch);
	Print("%-30.30s: %d\n","InteractiveMode",InteractiveMode);
	Print("%-30.30s: %d\n","LevelsMax",LevelsMax);
	Print("%-30.30s: %d\n","LevelsMin",LevelsMin);
	Print("%-30.30s: %s\n","MergeFile",MergeFile);
	Print("%-30.30s: %lf\n","MergeThreshHold",MergeThreshHold);
	Print("%-30.30s: %d\n","MinPixels",MinPixels);
	Print("%-30.30s: %d\n","Morph_Across",Morph_Across);
	Print("%-30.30s: %d\n","Morph_Debug",Morph_Debug);
	Print("%-30.30s: %d\n","Morph_Down",Morph_Down);
	Print("%-30.30s: %d\n","Morph_Drift",Morph_Drift);
	Print("%-30.30s: %d\n","Morph_Iterations",Morph_Iterations);
	Print("%-30.30s: %d\n","Morph_MaxTranslate",Morph_MaxTranslate);
	Print("%-30.30s: %d\n","Morph_Min_Divisor",Morph_Min_Divisor);
	Print("%-30.30s: %s\n","Morph_Ref",Morph_Ref);
	Print("%-30.30s: %d\n","Morphing",Morphing);
	Print("%-30.30s: %d\n","newHeight",newHeight);
	Print("%-30.30s: %d\n","newWidth",newWidth);
	Print("%-30.30s: %d\n","NoSave",NoSave);
	Print("%-30.30s: %s\n","OutDir",OutDir);
	Print("%-30.30s: %d\n","OutputFileDepth",OutputFileDepth);
	Print("%-30.30s: %d\n","OutputFileType",OutputFileType);
	Print("%-30.30s: %d\n","PopFilter",PopFilter);
	Print("%-30.30s: %d\n","PopFilter_When",PopFilter_When);
	Print("%-30.30s: %d\n","ProcessOffset",ProcessOffset);
	Print("%-30.30s: %d\n","ProcessSkip",ProcessSkip);
	Print("%-30.30s: %d\n","QEstimator",QEstimator);
	Print("%-30.30s: %s\n","QHISTO_FILE",QHISTO_FILE);
	Print("%-30.30s: %d\n","QHISTO_MAX",QHISTO_MAX);
	Print("%-30.30s: %d\n","QHISTO_MIN",QHISTO_MIN);
	Print("%-30.30s: %lf\n","QMargin",QMargin);
	Print("%-30.30s: %d\n","QRenumberFiles",QRenumberFiles);
	Print("%-30.30s: %d\n","QSUBSAMPLE_MAX",QSUBSAMPLE_MAX);
	Print("%-30.30s: %d\n","QSUBSAMPLE_MIN",QSUBSAMPLE_MIN);
	Print("%-30.30s: %d\n","QTrim",QTrim);
	Print("%-30.30s: %d\n","QualityFunction",QualityFunction);
	Print("%-30.30s: %d\n","Quiet",Quiet);
	Print("%-30.30s: %d\n","QWriteIntermediateFiles",QWriteIntermediateFiles);
	Print("%-30.30s: %lf\n","RotateAngle",RotateAngle);
	Print("%-30.30s: %d\n","RotateCutoff",RotateCutoff);
	Print("%-30.30s: %s\n","RunFile",RunFile);
	Print("%-30.30s: %d\n","SR_X1",SR_X1);
	Print("%-30.30s: %d\n","SR_X2",SR_X2);
	Print("%-30.30s: %d\n","SR_Y1",SR_Y1);
	Print("%-30.30s: %d\n","SR_Y2",SR_Y2);
	Print("%-30.30s: %d\n","StackCount",StackCount);
	Print("%-30.30s: %s\n","StackFile",StackFile);
	Print("%-30.30s: %d\n","StackMax",StackMax);
	Print("%-30.30s: %d\n","StreamFilter",StreamFilter);
	Print("%-30.30s: %d\n","StreamFilter_History",StreamFilter_History);
	Print("%-30.30s: %d\n","Sub_x",Sub_x);
	Print("%-30.30s: %d\n","Sub_y",Sub_y);
	Print("%-30.30s: %d\n","SubDirs",SubDirs);
	Print("%-30.30s: %lf\n","Subsample_max_offset",Subsample_max_offset);
	Print("%-30.30s: %lf\n","Subsample_min_offset",Subsample_min_offset);
	Print("%-30.30s: %d\n","Subsample_nframes",Subsample_nframes);
	Print("%-30.30s: %d\n","Subsample_noise",Subsample_noise);
	Print("%-30.30s: %d\n","Subsample_pixel_height",Subsample_pixel_height);
	Print("%-30.30s: %d\n","Subsample_pixel_width",Subsample_pixel_width);
	Print("%-30.30s: %s\n","Subsample_prefix",Subsample_prefix);
	Print("%-30.30s: %d\n","Subsample_scan",Subsample_scan);
	Print("%-30.30s: %d\n","Subsample_smooth",Subsample_smooth);
	Print("%-30.30s: %d\n","Subsample_upscale",Subsample_upscale);
	Print("%-30.30s: %d\n","Subsample_xpixels",Subsample_xpixels);
	Print("%-30.30s: %d\n","Subsample_ypixels",Subsample_ypixels);
	Print("%-30.30s: %d\n","SubsampleMode",SubsampleMode);
	Print("%-30.30s: %d\n","ThreshHold",ThreshHold);
	Print("%-30.30s: %d\n","UpScale",UpScale);
	Print("%-30.30s: %d\n","UpScale_Smoothing",UpScale_Smoothing);
	Print("%-30.30s: %d\n","UpScale_Smoothing_When",UpScale_Smoothing_When);
	Print("%-30.30s: %d\n","White",White);
	Print("%-30.30s: %d\n","WriteEmptyFiles",WriteEmptyFiles);
	}
