#define COLOR_FORMAT7_MONO8 	1
#define COLOR_FORMAT7_YUV411	2
#define COLOR_FORMAT7_YUV422	3
#define COLOR_FORMAT7_YUV444	4
#define COLOR_FORMAT7_RGB8	5
#define COLOR_FORMAT7_MONO16	6
#define COLOR_FORMAT7_RGB16	7

#if defined(__MINGW32__) || defined(__MINGW64__)
#define MSWIN32
#endif

#include "ninox.h"
#include <time.h>
#include "SDL/SDL.h"

#ifndef MSWIN32
#include <X11/Xlib.h>
#include <X11/extensions/Xvlib.h>
#include <ctype.h>

#define HAVE_XV
#endif

typedef struct _xvinfo
{
#ifdef HAVE_XV
  Display *dpy;
  XvAdaptorInfo *ainfo;
  XvEncodingInfo *encodings;
  XvImageFormatValues *formats;
  unsigned int nencode, nadaptors;
  int numImages;
  int ImageEncodings;
#endif
  int max_height;
  int max_width;
} xvinfo_t;

int CreateProperty(int brightness, double gain, double gamma);

void SetProperty_brightness(int p, int brightness);
void SetProperty_gain(int p, double gain);
void SetProperty_gamma(int p, double gamma);

int AdjustProperty_brightness(int p, int brightness);
double AdjustProperty_gain(int p, double gain);
double AdjustProperty_gamma(int p, double gamma);
void DeleteProperty(int p);

int GetDisplayWidth(void);
int GetDisplayHeight(void);

int InitProperties(void);
int InitDisplay(char *caption, int width, int height, int bpp);
int DisplayImage(struct Image *img, int p, int x_off,int y_off);
void ShutdownDisplay(void);

void Message(char *str);
void FatalError(char *str);

