/* THIS FILE IS AUTO-GENERATED, DO NOT EDIT */

#define VALUE_B (bval)
#define VALUE_S (val)
#define VALUE_I atoi(val)
#define VALUE_F atof(val)
#define BOOLEAN(x) ((x)=(bval==1?1:0))
#define RETURN return(1)
#define FAIL return(-1)
// Assign quality anyway, even if image contains overbright pixels

#include "ninox.h"

int _CMD_amean(char *arg, char *val, int bval)
	{
	BOOLEAN(AMean);
	return(1);
	}

int _HLP__CMD_amean(char *arg, char *val, int bval)
	{
	Print("\nHelp for '%s'\n\n","amean");
	Print("	Enable the alpha-trimmed-mean smoothing algorithm\n");
	exit(0);
	}

int _CMD_antighost(char *arg, char *val, int bval)
	{
	int ch;
	if (sscanf(VALUE_S,"%d,%d,%d",&AG_X,&AG_Y,&AG_MAG) == 3) {
	   AntiGhostEnable = 1;
	   Print("Enabling Antighost: x=%d, y=%d val=%d\n",AG_X,AG_Y,AG_MAG);
	   }
	return(1);
	}

int _CMD_archiveoverridefilenames(char *arg, char *val, int bval)
	{
	BOOLEAN(ArchiveOverrideFilenames);
	return(1);
	}

int _HLP__CMD_archiveoverridefilenames(char *arg, char *val, int bval)
	{
	Print("\nHelp for '%s'\n\n","archiveoverridefilenames");
	Print("	no help available\n");
	exit(0);
	}

int _CMD_autoblack(char *arg, char *val, int bval)
	{
	BOOLEAN(AutoBlack);
	return(1);
	}

int _HLP__CMD_autoblack(char *arg, char *val, int bval)
	{
	Print("\nHelp for '%s'\n\n","autoblack");
	Print("	Automatically detect black level in images by scanning top and\n");
	Print("	bottom rows, subtract average value from all pixels\n");
	exit(0);
	}

int _CMD_bayer8(char *arg, char *val, int bval)
	{
	BOOLEAN(Bayer8);
	return(1);
	}

int _CMD_bayer_x(char *arg, char *val, int bval)
	{
	BayerX = VALUE_I;
	return(1);
	}

int _CMD_bayer_y(char *arg, char *val, int bval)
	{
	BayerY = VALUE_I;
	return(1);
	}

int _CMD_bayerboost(char *arg, char *val, int bval)
	{
	BayerBoost = VALUE_F;
	if (BayerBoost == 0) BayerBoost = 1.0;
	return(1);
	}

int _CMD_bias(char *arg, char *val, int bval)
	{
	Bias = VALUE_I;
	if (Bias>0) AutoBlack=0;
	return(1);
	}

int _HLP__CMD_bias(char *arg, char *val, int bval)
	{
	Print("\nHelp for '%s'\n\n","bias");
	Print("	bias is an amount to add onto pixels when we load the image.\n");
	Print("	It should be given as an 8 bit value (0-255) and it will\n");
	Print("	be scaled automatically to other depths\n");
	exit(0);
	}

int _CMD_bmp_ignore_offset(char *arg, char *val, int bval)
	{
	BOOLEAN(BmpIgnoreOffset);
	return(1);
	}

int _HLP__CMD_bmp_ignore_offset(char *arg, char *val, int bval)
	{
	Print("\nHelp for '%s'\n\n","bmp_ignore_offset");
	Print("	Ignore broken BMP header H.offset\n");
	exit(0);
	}

int _CMD_centrefunc(char *arg, char *val, int bval)
	{
	if (! strcasecmp(VALUE_S,"left"))  CentreMode = CENTRE_LEFT;
	if (! strcasecmp(VALUE_S,"right")) CentreMode = CENTRE_RIGHT;
	return(1);
	}

int _HLP__CMD_centrefunc(char *arg, char *val, int bval)
	{
	Print("\nHelp for '%s'\n\n","centrefunc");
	Print("	Determines how ninox finds the centre of an image to be cut out. The default\n");
	Print("	(ie if centrefunc is omitted) is to find the centre of brightness of the whole image\n");
	Print("	known as the barycentre.\n");
	Print("	\n");
	Print("	If you give centrefunc=left then this process is modified to only count the \"first\" \n");
	Print("	object found in the frame (scanning left -> right).\n");
	Print("	\n");
	Print("	If you give centrefunc=right then the process is modified to only count the \"first\"\n");
	Print("	object found in the frame scanning from right -> left.\n");
	Print("	\n");
	Print("	The \"left\" and \"right\" modes are useful when you want to lock onto one particular object\n");
	Print("	in a frame that contains other objects that are moving relative to the one you want, and\n");
	Print("	you want to ignore everything other than the first object (looking from either left or right).\n");
	Print("	\n");
	exit(0);
	}

int _CMD_chain(char *arg, char *val, int bval)
	{
	BOOLEAN(ChainArchives);
	return(1);
	}

int _HLP__CMD_chain(char *arg, char *val, int bval)
	{
	Print("\nHelp for '%s'\n\n","chain");
	Print("	When playing or processing FITS Archive files (.fta), automatically\n");
	Print("	chain from the end of one archive to the start of the next\n");
	exit(0);
	}

int _CMD_columncorrection(char *arg, char *val, int bval)
	{
	BOOLEAN(ColumnCorrection);
	if (VALUE_I > 1) ColumnCorrection = VALUE_I;
	return(1);
	}

int _HLP__CMD_columncorrection(char *arg, char *val, int bval)
	{
	Print("\nHelp for '%s'\n\n","columncorrection");
	Print("	Attempt to correct per-column gain inconsistencies by generating a\n");
	Print("	per-column correction to bring it back to the average\n");
	exit(0);
	}

int _CMD_config(char *arg, char *val, int bval)
	{
	char *params[128],*vals[128];
	char *c,*str,*cfgfile;
	int i,n,rval;
	cfgfile = strtok(val,",");
	if (! cfgfile || cfgfile[0]==0) {
	   printf("Error: Invalid filename for -config\n");
	   exit(1);
	   }
	if (access(cfgfile,R_OK)) {
	   printf("Error: Cannot find config file '%s'\n",cfgfile);
	   exit(1);
	   }
	// parse remainder of val into var=value tokens
	n=0;
#if 0
	while(str = strtok(NULL,",")) {
	   char *c = strchr(str,'=');
	   if (c) {
		*c=0;
		params[n] = strdup(str);
		vals[n++] = strdup(c+1);
		}
	   }
	params[n]=NULL;
	vals[n]=NULL;
	if (n) rval=LoadConfigFile(cfgfile,"ninox",params,vals);
	else
#endif
	rval=LoadConfigFile(cfgfile,"ninox",NULL,NULL);
	return rval;
	return(1);
	}

int _HLP__CMD_config(char *arg, char *val, int bval)
	{
	Print("\nHelp for '%s'\n\n","config");
	Print("	Allows a set of switches to be given in a file. Format is:\n");
	Print("	[ninox]\n");
	Print("	switch=value\n");
	Print("	switch=value\n");
	Print("	...\n");
	Print("	\n");
	Print("	Switches are given without the leading \'-\'\n");
	Print("	\n");
	Print("	The ini file is included with \"-ini=/path/to/file\"\n");
	exit(0);
	}

int _CMD_count(char *arg, char *val, int bval)
	{
	// How many images to process
	ImageCount=VALUE_I;
	return(1);
	}

int _CMD_cut(char *arg, char *val, int bval)
	{
	int x,y;
	if (sscanf(VALUE_S,"%d,%d",&x,&y)==2) {
		CutX = x;
		CutY = y;
	   	newWidth = CutX;
	   	newHeight = CutY;
		}
	else {
	   if (VALUE_I < 100 || VALUE_I>10000) {
		Print("%d: Outside valid bounds 100..10000\n",VALUE_I);
		FAIL;
		}
	   CutX = CutY = VALUE_I;
	   newWidth = CutX;
	   newHeight = CutY;
	   }
	return(1);
	}

int _CMD_cutx(char *arg, char *val, int bval)
	{
	CutX = VALUE_I;
	if (CutX < 100) {
	   Print("-cutx: minimum supported size 100 pixels\n");
	   FAIL;
	   }
	return(1);
	}

int _CMD_cuty(char *arg, char *val, int bval)
	{
	CutY = VALUE_I;
	if (CutY < 100) {
	   Print("-cutx: minimum supported size 100 pixels\n");
	   FAIL;
	   }
	return(1);
	}

int _CMD_darkframe(char *arg, char *val, int bval)
	{
         BOOLEAN(DoDarkFrameSubtract);
         if (DoDarkFrameSubtract && ! LoadDarkFrameRef(VALUE_S)) {
               Print("Error loading dark frame reference '%s'\n",VALUE_S);
               FAIL;
               }
	return(1);
	}

int _CMD_dbf_diff(char *arg, char *val, int bval)
	{
	DBF_DIFF = VALUE_I;
	return(1);
	}

int _HLP__CMD_dbf_diff(char *arg, char *val, int bval)
	{
	Print("\nHelp for '%s'\n\n","dbf_diff");
	Print("	Maximum number of images to generate\n");
	exit(0);
	}

int _CMD_dbfedgecount(char *arg, char *val, int bval)
	{
	DBF_EDGE_COUNT = VALUE_I;
	return(1);
	}

int _HLP__CMD_dbfedgecount(char *arg, char *val, int bval)
	{
	Print("\nHelp for '%s'\n\n","dbfedgecount");
	Print("	With detectbrokenframes, this sets a threshhold for detecting\n");
	Print("	broken frames.\n");
	exit(0);
	}

int _CMD_debayer(char *arg, char *val, int bval)
	{
	if (VALUE_I) DoDeBayer = VALUE_I;
	else {
	   if (! strcasecmp(VALUE_S,"gbg")) DoDeBayer=1;
	   if (! strcasecmp(VALUE_S,"rgr")) DoDeBayer=2;
	   if (! strcasecmp(VALUE_S,"bgb")) DoDeBayer=3;
	   if (! strcasecmp(VALUE_S,"grg")) DoDeBayer=4;
	   }
	return(1);
	}

int _CMD_debug(char *arg, char *val, int bval)
	{
	BOOLEAN(DEBUG);
	return(1);
	}

int _CMD_default_config(char *arg, char *val, int bval)
	{
	ShowGlobals();
	exit(1);
	return(1);
	}

int _CMD_detectbrokenframes(char *arg, char *val, int bval)
	{
	if (!strcasecmp(VALUE_S,"planet")) DBF_TYPE = DBF_PLANET;
	else if (!strcasecmp(VALUE_S,"lunar")) DBF_TYPE = DBF_LUNAR;
	else if (!strcasecmp(VALUE_S,"moon")) DBF_TYPE = DBF_LUNAR;
	DetectBrokenFrames = 1;
	return(1);
	}

int _HLP__CMD_detectbrokenframes(char *arg, char *val, int bval)
	{
	Print("\nHelp for '%s'\n\n","detectbrokenframes");
	Print("	ninox will use an algorithm to detect corrupted (broken) frames\n");
	Print("	by comparing each frame to its predecessor. Sudden large-scale\n");
	Print("	changes are interpreted as corruption and the frame is skipped.\n");
	exit(0);
	}

int _CMD_detecthotpixels(char *arg, char *val, int bval)
	{
	BOOLEAN(DetectHotPixels);
	return(1);
	}

int _CMD_display(char *arg, char *val, int bval)
	{
	DisplayFrames = 1;
	if (! strcasecmp(VALUE_S,"pause")) DisplayPause=1;
	return(1);
	}

int _CMD_dofft(char *arg, char *val, int bval)
	{
	double r1,r2,p;
	if (sscanf(VALUE_S,"%lf,%lf,%lf",&r1,&r2,&p) == 3) {
	   /* 3 operand version, all params given */
	   FFT_LPF_Radius1 = r1;
	   FFT_LPF_Radius2 = r2;
	   FFT_LPF_Pow = p;
	   }
	else if (sscanf(VALUE_S,"%lf,%lf",&r1,&r2) == 2) {
	   /* 2 operand version, assume p = 1 */
	   FFT_LPF_Radius1 = r1;
	   FFT_LPF_Radius2 = r2;
	   FFT_LPF_Pow = 1.0;
	   }
	else if (sscanf(VALUE_S,"%lf",&r1) == 1) {
	   /* single operand version, assume r2 = r1 * 2 and p = 1 */
	   FFT_LPF_Radius1 = r1;
	   FFT_LPF_Radius2 = r1 * 2.0;
	   FFT_LPF_Pow = 1.0;
	   }
	else {
	   FFT_LPF_Radius1 = 0;
	   FFT_LPF_Radius2 = 0;
	   FFT_LPF_Pow = 0;
	   }
	   
	DoFFT = 1;
	
	return(1);
	}

int _CMD_dorenumber(char *arg, char *val, int bval)
	{
	AllowOverwrite=1;
	QRenumber(QRenumberFiles);
	return(1);
	}

int _CMD_enablecutout(char *arg, char *val, int bval)
	{
	BOOLEAN(DoCutout);
	if (! VALUE_B) ForceProcess=1;
	return(1);
	}

int _HLP__CMD_enablecutout(char *arg, char *val, int bval)
	{
	Print("\nHelp for '%s'\n\n","enablecutout");
	Print("	ninox will attempt to locate and centre the dominant object in the\n");
	Print("	frame by finding the centre of brightness and \"cutting out\" a rectangle\n");
	Print("	around that point and moving it to the centre of the image.\n");
	exit(0);
	}

int _CMD_fft_filter(char *arg, char *val, int bval)
	{
	double r1,r2,p;
	if (sscanf(VALUE_S,"%lf,%lf,%lf",&r1,&r2,&p) == 3) {
	   /* 3 operand version, all params given */
	   FFT_LPF_Radius1 = r1;
	   FFT_LPF_Radius2 = r2;
	   FFT_LPF_Pow = p;
	   }
	else if (sscanf(VALUE_S,"%lf,%lf",&r1,&r2) == 2) {
	   /* 2 operand version, assume p = 1 */
	   FFT_LPF_Radius1 = r1;
	   FFT_LPF_Radius2 = r2;
	   FFT_LPF_Pow = 1.0;
	   }
	else if (sscanf(VALUE_S,"%lf",&r1) == 1) {
	   /* single operand version, assume r2 = r1 * 2 and p = 1 */
	   FFT_LPF_Radius1 = r1;
	   FFT_LPF_Radius2 = r1 * 2.0;
	   FFT_LPF_Pow = 1.0;
	   }
	else {
	   Print("fft-filter: Error, usage is fft-filter=r1,r2,p\n");
	   exit(1);
	   }
	FFT_Filter = 1;
	   
	return(1);
	}

int _CMD_fft_ref(char *arg, char *val, int bval)
	{
	FFT_Ref = strdup(VALUE_S);
	DoFFT = 1;
	return(1);
	}

int _CMD_fft_scan(char *arg, char *val, int bval)
	{
	FFT_Region = VALUE_I;
	return(1);
	}

int _CMD_flux(char *arg, char *val, int bval)
	{
	SumFlux = 1;
	FluxFile = VALUE_S;
	return(1);
	}

int _CMD_forceprocess(char *arg, char *val, int bval)
	{
	BOOLEAN(ForceProcess);
	return(1);
	}

int _CMD_gain(char *arg, char *val, int bval)
	{
	Gain = VALUE_F;
	if (Gain != 1.0) ChangeGain = 1;
	return(1);
	}

int _CMD_gaincomp(char *arg, char *val, int bval)
	{
         BOOLEAN(ApplyGainComp);
         if (ApplyGainComp && ! LoadGainCompRef(VALUE_S)) {
               Print("Error loading gain compensation reference\n");
               FAIL;
               }
	return(1);
	}

int _CMD_gamma(char *arg, char *val, int bval)
	{
	double g = VALUE_F;
	if (g < 0.3 || g > 2.5) {
	   Print("Gamma value %f is outside accepted range 0.3 <= gamma <= 1.5\n",g);
	   FAIL;
	   }
	Gamma = g;
	if (Gamma != 1.0) ChangeGamma = 1;
	return(1);
	}

int _CMD_gc_deadcol(char *arg, char *val, int bval)
	{
	GaincompDeadColList[GaincompDeadColCount++] = VALUE_I;
	return(1);
	}

int _CMD_gcboost(char *arg, char *val, int bval)
	{
	GaincompBoost = VALUE_F;
	return(1);
	}

int _CMD_gcderingamount(char *arg, char *val, int bval)
	{
	GaincompDeRingAmount = VALUE_F;
	return(1);
	}

int _CMD_gcderingamount2(char *arg, char *val, int bval)
	{
	GaincompDeRingAmount2 = VALUE_F;
	return(1);
	}

int _CMD_gcderingdelay(char *arg, char *val, int bval)
	{
	GaincompDeRingDelay = VALUE_I;
	return(1);
	}

int _CMD_grey(char *arg, char *val, int bval)
	{
	BOOLEAN(Grey);
	return(1);
	}

int _HLP__CMD_grey(char *arg, char *val, int bval)
	{
	Print("\nHelp for '%s'\n\n","grey");
	Print("	Converts 24bpp input into 8bpp monochrome\n");
	exit(0);
	}

int _CMD_height(char *arg, char *val, int bval)
	{
	newHeight = VALUE_I;
	if (newHeight < 100 || newHeight > 10000) {
	   Print("Height must be 100..10000\n");
	   FAIL;
	   }
	return(1);
	}

int _CMD_help(char *arg, char *val, int bval)
	{
	int i;
	Print("\nUsage: ninox [ switches] [files or directories]\n\n");
	Print("Switches: \n\n");
	for(i=0; Names[i].func != NULL; ++i)
	   if (! strstr(Names[i].option,"help-"))
		Print("-%s ",Names[i].option);
	Print("\n\n");
	Print("Use \"ninox -help-X\" to see detailed help about switch X\n\n");
	exit(0);
	
	return(1);
	}

int _CMD_hist(char *arg, char *val, int bval)
	{
	BOOLEAN(ShowHistogram);
	return(1);
	}

int _HLP__CMD_hist(char *arg, char *val, int bval)
	{
	Print("\nHelp for '%s'\n\n","hist");
	Print("	Usage: -hist  show histogram of image\n");
	exit(0);
	}

int _CMD_histo_warning(char *arg, char *val, int bval)
	{
	BOOLEAN(EnableHistoWarning);
	return(1);
	}

int _HLP__CMD_histo_warning(char *arg, char *val, int bval)
	{
	Print("\nHelp for '%s'\n\n","histo_warning");
	Print("	Usage: -histo-warning=off  OR  -nohisto-warning\n");
	exit(0);
	}

int _CMD_hnoisefilter(char *arg, char *val, int bval)
	{
	BOOLEAN(HNoiseFilter);
	return(1);
	}

int _CMD_i(char *arg, char *val, int bval)
	{
	BOOLEAN(InteractiveMode);
	return(1);
	}

int _HLP__CMD_i(char *arg, char *val, int bval)
	{
	Print("\nHelp for '%s'\n\n","i");
	Print("	Enter interactive mode\n");
	exit(0);
	}

int _CMD_input_type(char *arg, char *val, int bval)
	{
	if (!strcasecmp(VALUE_S,"bmp")) 	InputFileType = IMG_BMP;
	else if (!strncasecmp(VALUE_S,"fit",3)) InputFileType = IMG_FIT;
	else if (!strcasecmp(VALUE_S,"ppm")) 	InputFileType = IMG_PPM;
	else {
	   Print("input file type '%s' not understood\n",VALUE_S);
	   FAIL;
	   }
	return(1);
	}

int _CMD_inputfilter(char *arg, char *val, int bval)
	{
	if (InputFilter==0 && VALUE_F > 0) InputFilter_ThreshHold = VALUE_F;
	++InputFilter;
	return(1);
	}

int _HLP__CMD_inputfilter(char *arg, char *val, int bval)
	{
	Print("\nHelp for '%s'\n\n","inputfilter");
	Print("	Enables an input filter algorithm which replaces pixels that are too bright/dark\n");
	Print("	when compared to their neighbors. favours dark pixels.\n");
	exit(0);
	}

int _CMD_inputfilter_display(char *arg, char *val, int bval)
	{
	BOOLEAN(InputFilter_Display);
	return(1);
	}

int _HLP__CMD_inputfilter_display(char *arg, char *val, int bval)
	{
	Print("\nHelp for '%s'\n\n","inputfilter_display");
	Print("	Display the action of the input filter\n");
	exit(0);
	}

int _CMD_invert(char *arg, char *val, int bval)
	{
	BOOLEAN(doInvertImage);
	return(1);
	}

int _HLP__CMD_invert(char *arg, char *val, int bval)
	{
	Print("\nHelp for '%s'\n\n","invert");
	Print("	Flip every second image vertically\n");
	exit(0);
	}

int _CMD_invert2(char *arg, char *val, int bval)
	{
	BOOLEAN(doInvertImage2);
	return(1);
	}

int _CMD_iquant(char *arg, char *val, int bval)
	{
	IQuant = VALUE_I;
	return(1);
	}

int _CMD_istretch(char *arg, char *val, int bval)
	{
	BOOLEAN(InputHistoStretch);
	if (VALUE_F > 0 && VALUE_F < 1) {
	   MAX_STRETCH = VALUE_F;
	   InputHistoStretch = 1;
	   }
	return(1);
	}

int _HLP__CMD_istretch(char *arg, char *val, int bval)
	{
	Print("\nHelp for '%s'\n\n","istretch");
	Print("	Stretches the input image to have the brightest pixel at 80% (default, can be changed with the mstretch option)\n");
	Print("	\n");
	exit(0);
	}

int _CMD_levels(char *arg, char *val, int bval)
	{
	int min,max;
	if (sscanf(val,"%d,%d",&min,&max) != 2) {
	   printf("syntax error on 'levels'\n");
	   FAIL;
	   }
	LevelsMin = min;
	LevelsMax = max;
	doLevelsAdjust = 1;
	return(1);
	}

int _HLP__CMD_levels(char *arg, char *val, int bval)
	{
	Print("\nHelp for '%s'\n\n","levels");
	Print("	Applies a histogram stretch to each frame, setting the black and white levels according\n");
	Print("	to the values given in the -levels=MIN,MAX argument. MIN and MAX are given as 8 bit values\n");
	Print("	and will be automatically converted to 16 bit if required.\n");
	exit(0);
	}

int _CMD_loadqfile(char *arg, char *val, int bval)
	{
	Print("Loading quality values from %s\n",val);
	LoadQFile(val);
	return(1);
	}

int _CMD_maxallowedmovement(char *arg, char *val, int bval)
	{
	MaxAllowedMovement = VALUE_I;
	return(1);
	}

int _HLP__CMD_maxallowedmovement(char *arg, char *val, int bval)
	{
	Print("\nHelp for '%s'\n\n","maxallowedmovement");
	Print("	maxallowedmovement=N instructs ninox to drop any frames where the barycentre shifts by\n");
	Print("	N pixels or more between successive frames. Requires imagetracking to be enabled.\n");
	exit(0);
	}

int _CMD_mean3(char *arg, char *val, int bval)
	{
	BOOLEAN(Do3x3Smooth);
	return(1);
	}

int _HLP__CMD_mean3(char *arg, char *val, int bval)
	{
	Print("\nHelp for '%s'\n\n","mean3");
	Print("	Enable a 3x3 mean smoothing on the image\n");
	exit(0);
	}

int _CMD_mergefile(char *arg, char *val, int bval)
	{
	MergeFile = strdup(VALUE_S);
	return(1);
	}

int _CMD_mergethreshhold(char *arg, char *val, int bval)
	{
	MergeThreshHold = VALUE_F;
	return(1);
	}

int _CMD_minpixels(char *arg, char *val, int bval)
	{
	MinPixels = VALUE_I;
	if (MinPixels<5 || MinPixels > 1000) {
	   Print("Minpixels: %d out of allowed range 10..1000\n",MinPixels);
	   FAIL;
	   }
	return(1);
	}

int _CMD_minq(char *arg, char *val, int bval)
	{
	MinQuality = VALUE_F;
	return(1);
	}

int _HLP__CMD_minq(char *arg, char *val, int bval)
	{
	Print("\nHelp for '%s'\n\n","minq");
	Print("	Only keep frames that reach this quality\n");
	exit(0);
	}

int _CMD_mirror(char *arg, char *val, int bval)
	{
	BOOLEAN(doMirrorImage);
	return(1);
	}

int _HLP__CMD_mirror(char *arg, char *val, int bval)
	{
	Print("\nHelp for '%s'\n\n","mirror");
	Print("	Flip the image vertically\n");
	exit(0);
	}

int _CMD_mkdirs(char *arg, char *val, int bval)
	{
	BOOLEAN(MkDirs);
	return(1);
	}

int _HLP__CMD_mkdirs(char *arg, char *val, int bval)
	{
	Print("\nHelp for '%s'\n\n","mkdirs");
	Print("	Usage: -mkdirs=yes\n");
	Print("	Creates all parent directories for the -outdir directory\n");
	exit(0);
	}

int _CMD_morph_across(char *arg, char *val, int bval)
	{
	// Number of control points across the image
	Morph_Across = VALUE_I;
	return(1);
	}

int _CMD_morph_de(char *arg, char *val, int bval)
	{
	// Enable extra debugging
	Morph_Debug = VALUE_I;
	printf("[%d]\n",Morph_Debug);
	return(1);
	}

int _CMD_morph_down(char *arg, char *val, int bval)
	{
	// Number of control points down the image
	Morph_Down = VALUE_I;
	
	return(1);
	}

int _CMD_morph_dr(char *arg, char *val, int bval)
	{
	Morph_Drift = VALUE_I;
	return(1);
	}

int _CMD_morph_it(char *arg, char *val, int bval)
	{
	// Number of morph iterations to run
	Morph_Iterations = VALUE_I;
	return(1);
	}

int _CMD_morph_max_translate(char *arg, char *val, int bval)
	{
	Morph_MaxTranslate = VALUE_I;
	return(1);
	}

int _CMD_morph_min_divisor(char *arg, char *val, int bval)
	{
	Morph_Min_Divisor = VALUE_I;
	
	return(1);
	}

int _CMD_morph_ref(char *arg, char *val, int bval)
	{
	Morph_Ref = strdup(VALUE_S);
	if (access(Morph_Ref,0)) {
	   Print("morph_ref: Reference image '%s' does not exist\n",val);
	   FAIL;
	   }
	return(1);
	}

int _CMD_morphing(char *arg, char *val, int bval)
	{
	Morphing = atoi(val);
	return(1);
	}

int _CMD_nocutout(char *arg, char *val, int bval)
	{
	DoCutout=0;
	ForceProcess = 1;
	return(1);
	}

int _HLP__CMD_nocutout(char *arg, char *val, int bval)
	{
	Print("\nHelp for '%s'\n\n","nocutout");
	Print("	Flip the image horizontally\n");
	exit(0);
	}

int _CMD_nosave(char *arg, char *val, int bval)
	{
	BOOLEAN(NoSave);
	return(1);
	}

int _CMD_outdir(char *arg, char *val, int bval)
	{
	int i;
	OutDir = strdup(VALUE_S);
	for(i=0; OutDir[i]; ++i) if (OutDir[i]=='\\') OutDir[i]='/';
	if (MkDirs) {
	   char *strtmp = strdup(OutDir);
	   char *ptr = strchr(strtmp,'/');
	   while(ptr) {
		*ptr = 0;
		if (! isDirectory(strtmp)) {
		   Print("Creating directory '%s'\n",strtmp);
		   Mkdir(strtmp);
		   if (! isDirectory(strtmp)) {
			Print("Mkdir on '%s' failed, cannot continue\n");
			exit(0);
			}
		   }
		else {
		   Print("Directory '%s' exists\n",strtmp);
		   }
		*ptr = '/';
		ptr = strchr(ptr+1,'/');
		}
	   free(strtmp);
	   }
	return(1);
	}

int _CMD_outdirappendsrc(char *arg, char *val, int bval)
	{
	BOOLEAN(OutDirAppendSrc);
	return(1);
	}

int _CMD_outdirprependsrc(char *arg, char *val, int bval)
	{
	BOOLEAN(OutDirPrependSrc);
	return(1);
	}

int _CMD_output_depth(char *arg, char *val, int bval)
	{
	OutputFileDepth = VALUE_I;
	if (OutputFileType < 0) OutputFileType = IMG_FIT;
	return(1);
	}

int _CMD_output_stack_depth(char *arg, char *val, int bval)
	{
	OutputStackFileDepth = VALUE_I;
	return(1);
	}

int _CMD_output_type(char *arg, char *val, int bval)
	{
	if (!strcasecmp(VALUE_S,"bmp")) 	OutputFileType = IMG_BMP;
	else if (!strncasecmp(VALUE_S,"fit",3)) OutputFileType = IMG_FIT;
	else if (!strcasecmp(VALUE_S,"ppm")) 	OutputFileType = IMG_PPM;
	else {
	   Print("output file type '%s' not understood\n",VALUE_S);
	   FAIL;
	   }
	return(1);
	}

int _CMD_overridechannel(char *arg, char *val, int bval)
	{
	int ch;
	int min,max;
	if (sscanf(VALUE_S,"%d=%d:%d",&ch,&min,&max) == 3) {
		OverrideChannel = 1;
		OverrideChannel_Value = ch;
		OverrideChannel_Min = min;
		OverrideChannel_Max = max;
		}
	return(1);
	}

int _HLP__CMD_overridechannel(char *arg, char *val, int bval)
	{
	Print("\nHelp for '%s'\n\n","overridechannel");
	Print("	can be used to explicitly set a range of frames to a specific channel, overriding\n");
	Print("	the automatic filename-based detection\n");
	exit(0);
	}

int _CMD_overwrite(char *arg, char *val, int bval)
	{
	BOOLEAN(AllowOverwrite);
	return(1);
	}

int _CMD_popfilter(char *arg, char *val, int bval)
	{
 	char when[32];
	int count,sz = 7;
	++PopFilter_PassCount;
	if (sscanf(VALUE_S,"%d,%d",&sz,&count) == 2) {
	   PopFilter_PassCount = count;
	   }
	else if (sscanf(VALUE_S,"%d,%s",&sz,when) == 2) {
	   if (!strcasecmp(when,"before")) PopFilter_When = POPFILTER_BEFORE;
	   else if (!strcasecmp(when,"after")) PopFilter_When = POPFILTER_AFTER;
	   else {
		Print("Unknown option '%s' to popfilter\n",when);
		FAIL;
		}
	   if (sz<=0) {
		Print("invalid size arg '%d' to popfilter\n",sz);
		FAIL;
		}
	   PopFilter = sz;
	   }
	else if (! strcasecmp(VALUE_S,"before")) {
		PopFilter_When = POPFILTER_BEFORE;
		PopFilter = sz;
		}
	else if (! strcasecmp(VALUE_S,"after")) {
		PopFilter_When = POPFILTER_AFTER;
		PopFilter = sz;
		}
	else if (VALUE_I > 0) {
		PopFilter = VALUE_I;
		PopFilter_When = POPFILTER_BEFORE;
		}
	else {
		PopFilter = sz;
		PopFilter_When = POPFILTER_BEFORE;
		}
	return(1);
	}

int _CMD_printflush(char *arg, char *val, int bval)
	{
	BOOLEAN(PrintFlush);
	return(1);
	}

int _HLP__CMD_printflush(char *arg, char *val, int bval)
	{
	Print("\nHelp for '%s'\n\n","printflush");
	Print("	Flush stdout after every print - boolean, default = NO\n");
	exit(0);
	}

int _CMD_process(char *arg, char *val, int bval)
	{
	// process=Offset,Skip for cooperatively processing a video sequence
	if (sscanf(VALUE_S,"%d,%d",&ProcessOffset,&ProcessSkip) != 2) {
	   printf("process: invalid argument, wanted process=offset,skip\n");
	   FAIL;
	   }
	return(1);
	}

int _HLP__CMD_process(char *arg, char *val, int bval)
	{
	Print("\nHelp for '%s'\n\n","process");
	Print("	Useful on multi-core or multi-processor machines. Allows you to specify\n");
	Print("	a subset of the available images to be processed on the assumption that\n");
	Print("	another invocation of ninox will be processing the skipped images.\n");
	Print("	\n");
	Print("	Usage: -process=offset,skip\n");
	Print("	\n");
	Print("	Offset is the starting image number (0 = first)\n");
	Print("	Skip is the number of images to skip after processing an image (default=0)\n");
	Print("	\n");
	Print("	eg, to run 2 copies of ninox, use:\n");
	Print("	\n");
	Print("	ninox -process=0,1 ...\n");
	Print("	and\n");
	Print("	ninox -process=1,1 ...\n");
	Print("	\n");
	Print("	with all other switches identical. The first invocation here will process\n");
	Print("	images 0,2,4,6,... and the second will process images 1,3,5,7 ...\n");
	exit(0);
	}

int _CMD_protect(char *arg, char *val, int bval)
	{
	BOOLEAN(HistoProtect);
	return(1);
	}

int _CMD_qcount(char *arg, char *val, int bval)
	{
	QualityMaxCount = VALUE_I;
	return(1);
	}

int _CMD_qestimator(char *arg, char *val, int bval)
	{
	int min,max,ch,step;
	BOOLEAN(QEstimator);
	// Possible value "n,m" representing min and max subsampling
	// or "n,m,i" for sampling between n and m with increment i
	if (sscanf(val,"%d%c%d%c%d",&min,&ch,&max,&ch,&step)==5) {
	   QSUBSAMPLE_MIN = min;
	   QSUBSAMPLE_MAX = max;
	   QSUBSAMPLE_INC = step;
	   QEstimator = 1;
	   }
	else if (sscanf(val,"%d%c%d",&min,&ch,&max)==3) {
	   QSUBSAMPLE_MIN = min;
	   QSUBSAMPLE_MAX = max;
	   QEstimator = 1;
	   }
	else if (sscanf(val,"%d",&min)==1) {
	   QSUBSAMPLE_MIN = min;
	   QSUBSAMPLE_MAX = min;
	   QEstimator = 1;
	   }
	return(1);
	}

int _CMD_qf_ignorehistowarning(char *arg, char *val, int bval)
	{
	BOOLEAN(IGNORE_HISTO_WARNING);
	return(1);
	}

int _CMD_qfunc(char *arg, char *val, int bval)
	{
	if (! strncasecmp(VALUE_S,"hist",4)) QualityFunction = HISTO;
	else if (! strncasecmp(VALUE_S,"none",4))   QualityFunction = QF_NONE; // Keep original order
	else if (! strncasecmp(VALUE_S,"grad",4))   QualityFunction = GRADIENT; // default
	else if (! strncasecmp(VALUE_S,"thresh",4)) QualityFunction = BR_THRESH;
	else if (! strncasecmp(VALUE_S,"+thresh",4)) QualityFunction = ADD_BR_THRESH;
	else if (! strncasecmp(VALUE_S,"mincount",4)) QualityFunction = QF_MINCOUNT;
	else if (! strncasecmp(VALUE_S,"sosq",4)) QualityFunction = QF_SOSQ;
	else if (! strncasecmp(VALUE_S,"aperture:",9)) {
		int r = atoi(VALUE_S+9);
		if (r>0) QF_APERTURE_RADIUS = r;
		else {
		   Print("QF_Aperture: No radius given, format is qfunc=aperture:R\n");
		   exit(1);
		   }
		QualityFunction = QF_APERTURE;
		}
	else {
		printf("Unknown quality function '%s'\n",val);
		FAIL;
		}
	// Set defaults if we haven't given them on the commandline
	QEstimator = 1;
	if (! QRenumberFiles) QRenumberFiles = 1;
	return(1);
	}

int _CMD_qhistfile(char *arg, char *val, int bval)
	{
	   QHISTO_FILE = strdup(VALUE_S);
	return(1);
	}

int _CMD_qhisto(char *arg, char *val, int bval)
	{
	int x1,y1,x2,y2,min,max;
	if (sscanf(val,"%d,%d-%d,%d:%d-%d",&x1,&y1,&x2,&y2,&min,&max)==6)
		QAddRegion(x1,y1,x2,y2,min,max);
	if (sscanf(val,"%d,%d",&min,&max)==2) {
	   	QHISTO_MIN = min;
		QHISTO_MAX = max;
		}
	else {
		printf("Usage: -qhisto=min,max (8 bit values)\n");
		FAIL;
		}
	return(1);
	}

int _CMD_qmargin(char *arg, char *val, int bval)
	{
	   // -qmargin=0.25 for 25% margin on all borders
	   QMargin = VALUE_F;
	return(1);
	}

int _CMD_qprefix(char *arg, char *val, int bval)
	{
	QPR = strdup(VALUE_S);
	return(1);
	}

int _CMD_qtrim(char *arg, char *val, int bval)
	{
        int b,a;
        // Check for time in seconds
        if (sscanf(val,"%ds,%ds",&b,&a) == 2) {
           QTrim_Before = b;
           QTrim_After = a;
           QTrim_Type = QTRIM_SECONDS;
           }
        // check for qtrim in frames
        else if (sscanf(val,"%d,%d",&b,&a) == 2) {
           QTrim_Before = b;
           QTrim_After = a;
           QTrim_Type = QTRIM_FRAMES;
           }
        else {
           QTrim_Before = QTrim_After = VALUE_I;
           QTrim_Type = QTRIM_FRAMES;
           }
	return(1);
	}

int _CMD_quiet(char *arg, char *val, int bval)
	{
	BOOLEAN(Quiet);
	return(1);
	}

int _CMD_qwrite(char *arg, char *val, int bval)
	{
	BOOLEAN(QWriteIntermediateFiles);
	return(1);
	}

int _CMD_qwrite_ser(char *arg, char *val, int bval)
	{
	QWriteSER = 1;
	QWriteSER_fname = strdup(VALUE_S);
	return(1);
	}

int _HLP__CMD_qwrite_ser(char *arg, char *val, int bval)
	{
	Print("\nHelp for '%s'\n\n","qwrite_ser");
	Print("	Write the quality-sorted frames into an SER archive\n");
	exit(0);
	}

int _CMD_qwrite_ser_count(char *arg, char *val, int bval)
	{
	QWriteSER_count = VALUE_I;
	
	return(1);
	}

int _HLP__CMD_qwrite_ser_count(char *arg, char *val, int bval)
	{
	Print("\nHelp for '%s'\n\n","qwrite_ser_count");
	Print("	The count of how many frames to write into the qwrite-ser file\n");
	Print("	Default is to write all frames\n");
	exit(0);
	}

int _CMD_renumber(char *arg, char *val, int bval)
	{
	int a;
	BOOLEAN(QRenumberFiles);
	if (!strcasecmp(VALUE_S,"last")) 
		QRenumberFiles = QRENUMBER_LAST;
	// qrenumber=preserve,50 means to keep the original
	// file order and keep the best 50%. Files lower than
	// the cutoff are deleted.
	if (sscanf(VALUE_S,"preserve,%d",&a) == 1)
		QRenumberPreserveOrder = a;
	return(1);
	}

int _CMD_rotate(char *arg, char *val, int bval)
	{
	RotateAngle = VALUE_F;
	if (RotateAngle != 0) do_Rotate=1;
	return(1);
	}

int _CMD_rotatecutoff(char *arg, char *val, int bval)
	{
	RotateCutoff = VALUE_I;
	return(1);
	}

int _CMD_rowbalance(char *arg, char *val, int bval)
	{
	BOOLEAN(doAutoRowBalance);
	return(1);
	}

int _CMD_rowboost(char *arg, char *val, int bval)
	{
	double v;
	if (sscanf(VALUE_S,"even,*%lf",&v)==1) {
		doRowBoost=1;
		RowBoostType = RB_EVEN_MULT;
		RowBoostMult = v;
		RowBoostAdd = 0;
		Print("rowboost: even rows: *= %lf\n",v);
		}
	else if (sscanf(VALUE_S,"even,+%lf",&v)==1) {
		doRowBoost=1;
		RowBoostType = RB_EVEN_ADD;
		RowBoostMult = 1.0;
		RowBoostAdd = v;
		Print("rowboost: even rows: += %lf\n",v);
		}
	else if (sscanf(VALUE_S,"odd,*%lf",&v)==1) {
		doRowBoost=1;
		RowBoostType = RB_ODD_MULT;
		RowBoostMult = v;
		RowBoostAdd = 0;
		Print("rowboost: odd rows: *= %lf\n",v);
		}
	else if (sscanf(VALUE_S,"odd,+%lf",&v)==1) {
		doRowBoost=1;
		RowBoostType = RB_ODD_ADD;
		RowBoostMult = 1.0;
		RowBoostAdd = v;
		Print("rowboost: odd rows: += %lf\n",v);
		}
	else {
	   Print("rowboost '%s' not understood\n",VALUE_S);
	   exit(1);
	   }
	return(1);
	}

int _HLP__CMD_rowboost(char *arg, char *val, int bval)
	{
	Print("\nHelp for '%s'\n\n","rowboost");
	Print("	Correct for odd/even row gain imbalances\n");
	Print("	rowboost=odd,x means boost odd rows by x (floating point) ie pixel *= x\n");
	Print("	rowboost=even,x means boost even rows by x (floating point) ie pixel *= x\n");
	exit(0);
	}

int _CMD_rowcorrection(char *arg, char *val, int bval)
	{
	BOOLEAN(RowCorrection);
	if (VALUE_I > 1) RowCorrection = VALUE_I;
	return(1);
	}

int _HLP__CMD_rowcorrection(char *arg, char *val, int bval)
	{
	Print("\nHelp for '%s'\n\n","rowcorrection");
	Print("	Attempt to correct per-row gain inconsistencies by generating a\n");
	Print("	per-row correction to bring it back to the average\n");
	exit(0);
	}

int _CMD_runfile(char *arg, char *val, int bval)
	{
	RunFile = strdup(VALUE_S);
	return(1);
	}

int _CMD_save(char *arg, char *val, int bval)
	{
	BOOLEAN(NoSave);
	NoSave = 1 - NoSave;
	return(1);
	}

int _CMD_scan(char *arg, char *val, int bval)
	{
	// give a non-central place to start scanning for FindCentre()
	int x1,y1;
	char fname[512];
	if (sscanf(VALUE_S,"%d,%d",&x1,&y1) != 2) {
	   printf("-scan: invalid format, should be -scan=x,y\n");
	   FAIL;
	   }
	Sub_x = x1;
	Sub_y = y1;
	return(1);
	}

int _CMD_showmovement(char *arg, char *val, int bval)
	{
	BOOLEAN(ShowMovement);
	return(1);
	}

int _HLP__CMD_showmovement(char *arg, char *val, int bval)
	{
	Print("\nHelp for '%s'\n\n","showmovement");
	Print("	showmovement=true will caluse ninox to print the distance between barycentres between\n");
	Print("	each frame as it is processed. imagetracking must be enabled for this option to work.\n");
	exit(0);
	}

int _CMD_smoothing(char *arg, char *val, int bval)
	{
	if (!strcasecmp(VALUE_S,"before")) {
	   UpScale_Smoothing_When = SMOOTHING_BEFORE;
	   UpScale_Smoothing = 1;
	   }
	else if (!strcasecmp(VALUE_S,"after")) {
	   UpScale_Smoothing_When = SMOOTHING_AFTER;
	   UpScale_Smoothing = 1;
	   }
	else BOOLEAN(UpScale_Smoothing);
	return(1);
	}

int _CMD_stack(char *arg, char *val, int bval)
	{
	StackFile = strdup(VALUE_S);
	return(1);
	}

int _CMD_stackcount(char *arg, char *val, int bval)
	{
	StackMax = VALUE_I;
	return(1);
	}

int _CMD_stdin(char *arg, char *val, int bval)
	{
	UsingStdin = 1;
	if (OutputFileType<0) OutputFileType = IMG_FIT;
	if (OutputFileDepth<0) OutputFileDepth = 16;
	return(1);
	}

int _HLP__CMD_stdin(char *arg, char *val, int bval)
	{
	Print("\nHelp for '%s'\n\n","stdin");
	Print("	Read frames from standard input\n");
	Print("	default to 16 bit .fit for output\n");
	exit(0);
	}

int _CMD_stdout(char *arg, char *val, int bval)
	{
	UsingStdout = 1;
	NoSave = 1;
	Select(stderr);
	return(1);
	}

int _HLP__CMD_stdout(char *arg, char *val, int bval)
	{
	Print("\nHelp for '%s'\n\n","stdout");
	Print("	Write frames to stdout\n");
	Print("	Also selects stderr for all normal Print() messages\n");
	exit(0);
	}

int _CMD_streamfilter(char *arg, char *val, int bval)
	{
	StreamFilter = 1;
	if (VALUE_I)
	   StreamFilter_History = VALUE_I;
	return(1);
	}

int _CMD_stretch(char *arg, char *val, int bval)
	{
	HistoStretch = VALUE_I;
	if (HistoStretch==0) HistoStretch = 200;
	return(1);
	}

int _CMD_subdirs(char *arg, char *val, int bval)
	{
	BOOLEAN(SubDirs);
	return(1);
	}

int _CMD_subregion(char *arg, char *val, int bval)
	{
	// subregion specifies a region to be used after the image has been centered
	// and cutout. This subregion replaces the centered image
	int x1,y1,x2,y2;
	char fname[512];
	if (sscanf(val,"%d,%d,%d,%d",&x1,&y1,&x2,&y2) != 4) {
	   printf("-subregion: Invalid format, should be -subregion=x1,y1,x2,y2\n");
	   FAIL;
	   }
	EnableSubRegion = 1;
	SR_X1 = x1;
	SR_X2 = x2;
	SR_Y1 = y1;
	SR_Y2 = y2;
	DoCutout=1;
	return(1);
	}

int _CMD_subsample_max_offset(char *arg, char *val, int bval)
	{
	Subsample_max_offset = VALUE_F;
	return(1);
	}

int _CMD_subsample_min_offset(char *arg, char *val, int bval)
	{
	Subsample_min_offset = VALUE_F;
	return(1);
	}

int _CMD_subsample_nframes(char *arg, char *val, int bval)
	{
	Subsample_nframes = VALUE_I;
	return(1);
	}

int _CMD_subsample_noise(char *arg, char *val, int bval)
	{
	Subsample_noise = VALUE_I;
	return(1);
	}

int _CMD_subsample_pixel_height(char *arg, char *val, int bval)
	{
	Subsample_pixel_height = VALUE_I;
	return(1);
	}

int _CMD_subsample_pixel_size(char *arg, char *val, int bval)
	{
	Subsample_pixel_height = Subsample_pixel_width = VALUE_I;
	return(1);
	}

int _CMD_subsample_pixel_width(char *arg, char *val, int bval)
	{
	Subsample_pixel_width = VALUE_I;
	return(1);
	}

int _CMD_subsample_prefix(char *arg, char *val, int bval)
	{
	Subsample_prefix = strdup(VALUE_S);
	return(1);
	}

int _CMD_subsample_scan(char *arg, char *val, int bval)
	{
	BOOLEAN(Subsample_scan);
	return(1);
	}

int _CMD_subsample_smooth(char *arg, char *val, int bval)
	{
	Subsample_smooth = VALUE_I;
	return(1);
	}

int _CMD_subsample_upscale(char *arg, char *val, int bval)
	{
	Subsample_upscale = VALUE_I;
	return(1);
	}

int _CMD_subsample_xpixels(char *arg, char *val, int bval)
	{
	Subsample_xpixels= VALUE_I;
	return(1);
	}

int _CMD_subsample_ypixels(char *arg, char *val, int bval)
	{
	Subsample_ypixels= VALUE_I;
	return(1);
	}

int _CMD_subsamplemode(char *arg, char *val, int bval)
	{
       SubsampleMode = VALUE_I;
       NoSave = 1;
	return(1);
	}

int _CMD_threshhold(char *arg, char *val, int bval)
	{
	int t = VALUE_I;
	if (t<5 || t > 250) {
	   Print("Threshhold %d out of allowed range 5..250\n",t);
	   FAIL;
	   }
	ThreshHold = t;
	return(1);
	}

int _CMD_tracking(char *arg, char *val, int bval)
	{
	ImageTracking = VALUE_I;
	if (ImageTracking < 10) {
	   printf("Error: tracking=%d: tracking box %dx%d not large enough\n",
		ImageTracking,ImageTracking,ImageTracking);
	   FAIL;
	   }
	return(1);
	}

int _HLP__CMD_tracking(char *arg, char *val, int bval)
	{
	Print("\nHelp for '%s'\n\n","tracking");
	Print("	tracking=N will cause ninox to remember the location of the image centre from\n");
	Print("	one frame to the next and search a box that is NxN, centered on the previous image\n");
	Print("	centre. This helps ninox to ignore transient objects that come in from the edge of screen\n");
	Print("	(eg moons or stars).\n");
	Print("	On the first frame the entire image is searched to locate the centre, unless you set\n");
	Print("	the initial location with Sub_x and Sub_y\n");
	exit(0);
	}

int _CMD_upscale(char *arg, char *val, int bval)
	{
	char *ptr = strstr(VALUE_S,"/");
	int up=1,down=1;
	if (ptr) {
	   *ptr = 0;
	   down = atoi(ptr+1);
	   }
	up = VALUE_I;
	if (up < 1 || up > 6 || down<1 || down>6) {
	   Print("UpScale: %d/%d out of accepted range (1..6)/(1..6) \n",up,down);
	   FAIL;
	   }
	UpScale = up;
	DownScale = down;
 	if (UpScale_Smoothing < 0) {
             double scalef = (double)UpScale / (double) DownScale;
             if (scalef < 1.4) UpScale_Smoothing = 0;
	     else UpScale_Smoothing = 1;
	     }
	return(1);
	}

int _CMD_white(char *arg, char *val, int bval)
	{
	White = VALUE_I;
	return(1);
	}

int _CMD_width(char *arg, char *val, int bval)
	{
	newWidth = VALUE_I;
	if (newWidth < 100 || newWidth>10000) {
	   Print("Width must be 100..10000\n");
	   FAIL;
	   }
	return(1);
	}

int _CMD_writeemptyfiles(char *arg, char *val, int bval)
	{
	BOOLEAN(forceWriteEmptyFiles);
	BOOLEAN(WriteEmptyFiles);
	return(1);
	}

int _CMD_xoffset(char *arg, char *val, int bval)
	{
	CutX_Offset = VALUE_I;
	return(1);
	}

int _CMD_yoffset(char *arg, char *val, int bval)
	{
	CutY_Offset = VALUE_I;
	return(1);
	}

int _CMD_zblack(char *arg, char *val, int bval)
	{
	ZBlack = VALUE_I;
	return(1);
	}

int _HLP__CMD_zblack(char *arg, char *val, int bval)
	{
	Print("\nHelp for '%s'\n\n","zblack");
	Print("	Used when decompressing .ftz archives, sets the background default\n");
	Print("	pixel brightness. range 0..255\n");
	exit(0);
	}



struct cfunc Names[] = {
	{"ablack" , _CMD_autoblack },
	{"help-ablack" , _HLP__CMD_autoblack },
	{"ag" , _CMD_antighost },
	{"amean" , _CMD_amean },
	{"help-amean" , _HLP__CMD_amean },
	{"antighost" , _CMD_antighost },
	{"archiveoverridefilenames" , _CMD_archiveoverridefilenames },
	{"help-archiveoverridefilenames" , _HLP__CMD_archiveoverridefilenames },
	{"autoblack" , _CMD_autoblack },
	{"help-autoblack" , _HLP__CMD_autoblack },
	{"bayer8" , _CMD_bayer8 },
	{"bayer_x" , _CMD_bayer_x },
	{"bayer_y" , _CMD_bayer_y },
	{"bayerboost" , _CMD_bayerboost },
	{"bias" , _CMD_bias },
	{"help-bias" , _HLP__CMD_bias },
	{"bmp-ignore-offset" , _CMD_bmp_ignore_offset },
	{"help-bmp-ignore-offset" , _HLP__CMD_bmp_ignore_offset },
	{"cc" , _CMD_columncorrection },
	{"help-cc" , _HLP__CMD_columncorrection },
	{"centrefunc" , _CMD_centrefunc },
	{"help-centrefunc" , _HLP__CMD_centrefunc },
	{"chain" , _CMD_chain },
	{"help-chain" , _HLP__CMD_chain },
	{"columncorrection" , _CMD_columncorrection },
	{"help-columncorrection" , _HLP__CMD_columncorrection },
	{"config" , _CMD_config },
	{"help-config" , _HLP__CMD_config },
	{"count" , _CMD_count },
	{"cut" , _CMD_cut },
	{"cutout" , _CMD_enablecutout },
	{"help-cutout" , _HLP__CMD_enablecutout },
	{"cutx" , _CMD_cutx },
	{"cuty" , _CMD_cuty },
	{"darkframe" , _CMD_darkframe },
	{"dbf" , _CMD_detectbrokenframes },
	{"help-dbf" , _HLP__CMD_detectbrokenframes },
	{"dbf-diff" , _CMD_dbf_diff },
	{"help-dbf-diff" , _HLP__CMD_dbf_diff },
	{"dbfedgecount" , _CMD_dbfedgecount },
	{"help-dbfedgecount" , _HLP__CMD_dbfedgecount },
	{"debayer" , _CMD_debayer },
	{"debug" , _CMD_debug },
	{"default-config" , _CMD_default_config },
	{"detectbrokenframes" , _CMD_detectbrokenframes },
	{"help-detectbrokenframes" , _HLP__CMD_detectbrokenframes },
	{"detecthotpixels" , _CMD_detecthotpixels },
	{"dhp" , _CMD_detecthotpixels },
	{"display" , _CMD_display },
	{"dofft" , _CMD_dofft },
	{"dorenumber" , _CMD_dorenumber },
	{"enablecutout" , _CMD_enablecutout },
	{"help-enablecutout" , _HLP__CMD_enablecutout },
	{"fft-filter" , _CMD_fft_filter },
	{"fft-ref" , _CMD_fft_ref },
	{"fft-scan" , _CMD_fft_scan },
	{"fft_scan" , _CMD_fft_scan },
	{"flipx" , _CMD_mirror },
	{"help-flipx" , _HLP__CMD_mirror },
	{"flipy" , _CMD_invert },
	{"help-flipy" , _HLP__CMD_invert },
	{"flipy2" , _CMD_invert2 },
	{"flux" , _CMD_flux },
	{"forceprocess" , _CMD_forceprocess },
	{"gain" , _CMD_gain },
	{"gaincomp" , _CMD_gaincomp },
	{"gamma" , _CMD_gamma },
	{"gc_deadcol" , _CMD_gc_deadcol },
	{"gcboost" , _CMD_gcboost },
	{"gcdeadcol" , _CMD_gc_deadcol },
	{"gcderingamount" , _CMD_gcderingamount },
	{"gcderingamount2" , _CMD_gcderingamount2 },
	{"gcderingdelay" , _CMD_gcderingdelay },
	{"grey" , _CMD_grey },
	{"help-grey" , _HLP__CMD_grey },
	{"height" , _CMD_height },
	{"help" , _CMD_help },
	{"hinvert" , _CMD_mirror },
	{"help-hinvert" , _HLP__CMD_mirror },
	{"hist" , _CMD_hist },
	{"help-hist" , _HLP__CMD_hist },
	{"histo-warning" , _CMD_histo_warning },
	{"help-histo-warning" , _HLP__CMD_histo_warning },
	{"hnoisefilter" , _CMD_hnoisefilter },
	{"i" , _CMD_i },
	{"help-i" , _HLP__CMD_i },
	{"ifd" , _CMD_inputfilter_display },
	{"help-ifd" , _HLP__CMD_inputfilter_display },
	{"ift" , _CMD_input_type },
	{"ini" , _CMD_config },
	{"help-ini" , _HLP__CMD_config },
	{"inifile" , _CMD_config },
	{"help-inifile" , _HLP__CMD_config },
	{"input-type" , _CMD_input_type },
	{"inputfilter" , _CMD_inputfilter },
	{"help-inputfilter" , _HLP__CMD_inputfilter },
	{"inputfilter-display" , _CMD_inputfilter_display },
	{"help-inputfilter-display" , _HLP__CMD_inputfilter_display },
	{"invert" , _CMD_invert },
	{"help-invert" , _HLP__CMD_invert },
	{"invert2" , _CMD_invert2 },
	{"iquant" , _CMD_iquant },
	{"istretch" , _CMD_istretch },
	{"help-istretch" , _HLP__CMD_istretch },
	{"levels" , _CMD_levels },
	{"help-levels" , _HLP__CMD_levels },
	{"loadqfile" , _CMD_loadqfile },
	{"ma" , _CMD_morph_across },
	{"maxallowedmovement" , _CMD_maxallowedmovement },
	{"help-maxallowedmovement" , _HLP__CMD_maxallowedmovement },
	{"maxcount" , _CMD_count },
	{"maxq" , _CMD_qfunc },
	{"md" , _CMD_morph_down },
	{"mdbg" , _CMD_morph_de },
	{"mdebug" , _CMD_morph_de },
	{"mean3" , _CMD_mean3 },
	{"help-mean3" , _HLP__CMD_mean3 },
	{"mean3x3" , _CMD_mean3 },
	{"help-mean3x3" , _HLP__CMD_mean3 },
	{"mergefile" , _CMD_mergefile },
	{"mergethreshhold" , _CMD_mergethreshhold },
	{"mi" , _CMD_morph_it },
	{"minpixels" , _CMD_minpixels },
	{"minq" , _CMD_minq },
	{"help-minq" , _HLP__CMD_minq },
	{"minquality" , _CMD_minq },
	{"help-minquality" , _HLP__CMD_minq },
	{"mirror" , _CMD_mirror },
	{"help-mirror" , _HLP__CMD_mirror },
	{"mkdirs" , _CMD_mkdirs },
	{"help-mkdirs" , _HLP__CMD_mkdirs },
	{"morph-across" , _CMD_morph_across },
	{"morph-de" , _CMD_morph_de },
	{"morph-down" , _CMD_morph_down },
	{"morph-dr" , _CMD_morph_dr },
	{"morph-drift" , _CMD_morph_dr },
	{"morph-it" , _CMD_morph_it },
	{"morph-iterations" , _CMD_morph_it },
	{"morph-max-translate" , _CMD_morph_max_translate },
	{"morph-min-divisor" , _CMD_morph_min_divisor },
	{"morph-ref" , _CMD_morph_ref },
	{"morph_across" , _CMD_morph_across },
	{"morph_debug" , _CMD_morph_de },
	{"morph_down" , _CMD_morph_down },
	{"morph_drift" , _CMD_morph_dr },
	{"morph_it" , _CMD_morph_it },
	{"morph_iterations" , _CMD_morph_it },
	{"morph_max_translate" , _CMD_morph_max_translate },
	{"morph_min_divisor" , _CMD_morph_min_divisor },
	{"morph_ref" , _CMD_morph_ref },
	{"morphing" , _CMD_morphing },
	{"mr" , _CMD_morph_ref },
	{"mstretch" , _CMD_istretch },
	{"help-mstretch" , _HLP__CMD_istretch },
	{"mx" , _CMD_morph_max_translate },
	{"nocutout" , _CMD_nocutout },
	{"help-nocutout" , _HLP__CMD_nocutout },
	{"nosave" , _CMD_nosave },
	{"ob" , _CMD_histo_warning },
	{"help-ob" , _HLP__CMD_histo_warning },
	{"od" , _CMD_output_depth },
	{"oft" , _CMD_output_type },
	{"osd" , _CMD_output_stack_depth },
	{"outdir" , _CMD_outdir },
	{"outdir-append-src" , _CMD_outdirappendsrc },
	{"outdir-prepend-src" , _CMD_outdirprependsrc },
	{"outdir_append_src" , _CMD_outdirappendsrc },
	{"outdir_prepend_src" , _CMD_outdirprependsrc },
	{"outdirappendsrc" , _CMD_outdirappendsrc },
	{"outdirprependsrc" , _CMD_outdirprependsrc },
	{"output-depth" , _CMD_output_depth },
	{"output-stack-depth" , _CMD_output_stack_depth },
	{"output-type" , _CMD_output_type },
	{"overbright" , _CMD_histo_warning },
	{"help-overbright" , _HLP__CMD_histo_warning },
	{"overridechannel" , _CMD_overridechannel },
	{"help-overridechannel" , _HLP__CMD_overridechannel },
	{"overwrite" , _CMD_overwrite },
	{"popfilter" , _CMD_popfilter },
	{"printflush" , _CMD_printflush },
	{"help-printflush" , _HLP__CMD_printflush },
	{"process" , _CMD_process },
	{"help-process" , _HLP__CMD_process },
	{"protect" , _CMD_protect },
	{"qc" , _CMD_qcount },
	{"qcount" , _CMD_qcount },
	{"qe" , _CMD_qestimator },
	{"qestimator" , _CMD_qestimator },
	{"qf" , _CMD_qfunc },
	{"qf_ignorehistowarning" , _CMD_qf_ignorehistowarning },
	{"qfile" , _CMD_loadqfile },
	{"qfunc" , _CMD_qfunc },
	{"qhistfile" , _CMD_qhistfile },
	{"qhisto" , _CMD_qhisto },
	{"qmargin" , _CMD_qmargin },
	{"qpr" , _CMD_qprefix },
	{"qprefix" , _CMD_qprefix },
	{"qrenumber" , _CMD_renumber },
	{"qsort" , _CMD_renumber },
	{"qtrim" , _CMD_qtrim },
	{"quiet" , _CMD_quiet },
	{"qwrite" , _CMD_qwrite },
	{"qwrite-ser" , _CMD_qwrite_ser },
	{"help-qwrite-ser" , _HLP__CMD_qwrite_ser },
	{"qwrite-ser-count" , _CMD_qwrite_ser_count },
	{"help-qwrite-ser-count" , _HLP__CMD_qwrite_ser_count },
	{"rc" , _CMD_rowcorrection },
	{"help-rc" , _HLP__CMD_rowcorrection },
	{"renumber" , _CMD_renumber },
	{"resample" , _CMD_upscale },
	{"rescale" , _CMD_upscale },
	{"rotate" , _CMD_rotate },
	{"rotatecutoff" , _CMD_rotatecutoff },
	{"rowbalance" , _CMD_rowbalance },
	{"rowboost" , _CMD_rowboost },
	{"help-rowboost" , _HLP__CMD_rowboost },
	{"rowcorrection" , _CMD_rowcorrection },
	{"help-rowcorrection" , _HLP__CMD_rowcorrection },
	{"runfile" , _CMD_runfile },
	{"save" , _CMD_save },
	{"scan" , _CMD_scan },
	{"showmovement" , _CMD_showmovement },
	{"help-showmovement" , _HLP__CMD_showmovement },
	{"smoothing" , _CMD_smoothing },
	{"stack" , _CMD_stack },
	{"stackcount" , _CMD_stackcount },
	{"stackfile" , _CMD_stack },
	{"stdin" , _CMD_stdin },
	{"help-stdin" , _HLP__CMD_stdin },
	{"stdout" , _CMD_stdout },
	{"help-stdout" , _HLP__CMD_stdout },
	{"streamfilter" , _CMD_streamfilter },
	{"stretch" , _CMD_stretch },
	{"subdirs" , _CMD_subdirs },
	{"subregion" , _CMD_subregion },
	{"subsample_max_offset" , _CMD_subsample_max_offset },
	{"subsample_min_offset" , _CMD_subsample_min_offset },
	{"subsample_nframes" , _CMD_subsample_nframes },
	{"subsample_noise" , _CMD_subsample_noise },
	{"subsample_pixel_height" , _CMD_subsample_pixel_height },
	{"subsample_pixel_size" , _CMD_subsample_pixel_size },
	{"subsample_pixel_width" , _CMD_subsample_pixel_width },
	{"subsample_prefix" , _CMD_subsample_prefix },
	{"subsample_scan" , _CMD_subsample_scan },
	{"subsample_smooth" , _CMD_subsample_smooth },
	{"subsample_upscale" , _CMD_subsample_upscale },
	{"subsample_xpixels" , _CMD_subsample_xpixels },
	{"subsample_ypixels" , _CMD_subsample_ypixels },
	{"subsamplemode" , _CMD_subsamplemode },
	{"threshhold" , _CMD_threshhold },
	{"tracking" , _CMD_tracking },
	{"help-tracking" , _HLP__CMD_tracking },
	{"trim" , _CMD_qtrim },
	{"upsample" , _CMD_upscale },
	{"upscale" , _CMD_upscale },
	{"white" , _CMD_white },
	{"width" , _CMD_width },
	{"writeemptyfiles" , _CMD_writeemptyfiles },
	{"xoffset" , _CMD_xoffset },
	{"yoffset" , _CMD_yoffset },
	{"zblack" , _CMD_zblack },
	{"help-zblack" , _HLP__CMD_zblack },
	{ "", NULL }};

int ShowGlobals()
	{
	Print("[ninox]\n");
	Print("AG_MAG=%d\n",AG_MAG);
	Print("AG_X=%d\n",AG_X);
	Print("AG_Y=%d\n",AG_Y);
	Print("AllowOverwrite=%d\n",AllowOverwrite);
	Print("AMean=%d\n",AMean);
	Print("AntiGhostEnable=%d\n",AntiGhostEnable);
	Print("ApplyGainComp=%d\n",ApplyGainComp);
	Print("ArchiveOverrideFilenames=%d\n",ArchiveOverrideFilenames);
	Print("AutoBlack=%d\n",AutoBlack);
	Print("Bayer8=%d\n",Bayer8);
	Print("BayerBoost=%lf\n",BayerBoost);
	Print("BayerX=%d\n",BayerX);
	Print("BayerY=%d\n",BayerY);
	Print("Bias=%d\n",Bias);
	Print("BmpIgnoreOffset=%d\n",BmpIgnoreOffset);
	Print("CentreMode=%d\n",CentreMode);
	Print("ChainArchives=%d\n",ChainArchives);
	Print("ChangeGain=%d\n",ChangeGain);
	Print("ChangeGamma=%d\n",ChangeGamma);
	Print("ColumnCorrection=%d\n",ColumnCorrection);
	Print("CurrentFile=%s\n",CurrentFile);
	Print("CutX=%d\n",CutX);
	Print("CutX_Offset=%d\n",CutX_Offset);
	Print("CutY=%d\n",CutY);
	Print("CutY_Offset=%d\n",CutY_Offset);
	Print("DBF_DIFF=%d\n",DBF_DIFF);
	Print("DBF_EDGE_COUNT=%d\n",DBF_EDGE_COUNT);
	Print("DBF_TYPE=%d\n",DBF_TYPE);
	Print("DEBUG=%d\n",DEBUG);
	Print("DetectBrokenFrames=%d\n",DetectBrokenFrames);
	Print("DetectHotPixels=%d\n",DetectHotPixels);
	Print("DisplayFrames=%d\n",DisplayFrames);
	Print("DisplayPause=%d\n",DisplayPause);
	Print("Do3x3Smooth=%d\n",Do3x3Smooth);
	Print("do_Rotate=%d\n",do_Rotate);
	Print("doAutoRowBalance=%d\n",doAutoRowBalance);
	Print("DoCutout=%d\n",DoCutout);
	Print("DoDarkFrameSubtract=%d\n",DoDarkFrameSubtract);
	Print("DoDeBayer=%d\n",DoDeBayer);
	Print("DoFFT=%d\n",DoFFT);
	Print("doInvertImage=%d\n",doInvertImage);
	Print("doInvertImage2=%d\n",doInvertImage2);
	Print("doLevelsAdjust=%d\n",doLevelsAdjust);
	Print("doMirrorImage=%d\n",doMirrorImage);
	Print("doRowBoost=%d\n",doRowBoost);
	Print("DownScale=%d\n",DownScale);
	Print("EnableHistoWarning=%d\n",EnableHistoWarning);
	Print("EnableSubRegion=%d\n",EnableSubRegion);
	Print("FFT_Filter=%d\n",FFT_Filter);
	Print("FFT_LPF_Pow=%lf\n",FFT_LPF_Pow);
	Print("FFT_LPF_Radius1=%lf\n",FFT_LPF_Radius1);
	Print("FFT_LPF_Radius2=%lf\n",FFT_LPF_Radius2);
	Print("FFT_Ref=%s\n",FFT_Ref);
	Print("FFT_Region=%d\n",FFT_Region);
	Print("FluxFile=%s\n",FluxFile);
	Print("ForceProcess=%d\n",ForceProcess);
	Print("forceWriteEmptyFiles=%d\n",forceWriteEmptyFiles);
	Print("Gain=%lf\n",Gain);
	Print("GaincompBoost=%lf\n",GaincompBoost);
	Print("GaincompDeadColCount=%d\n",GaincompDeadColCount);
	Print("GaincompDeadColList=%d\n",GaincompDeadColList);
	Print("GaincompDeRingAmount=%lf\n",GaincompDeRingAmount);
	Print("GaincompDeRingAmount2=%lf\n",GaincompDeRingAmount2);
	Print("GaincompDeRingDelay=%d\n",GaincompDeRingDelay);
	Print("Gamma=%lf\n",Gamma);
	Print("Grey=%d\n",Grey);
	Print("HaveWindow=%d\n",HaveWindow);
	Print("HistoProtect=%d\n",HistoProtect);
	Print("HistoStretch=%d\n",HistoStretch);
	Print("HNoiseFilter=%d\n",HNoiseFilter);
	Print("IGNORE_HISTO_WARNING=%d\n",IGNORE_HISTO_WARNING);
	Print("ImageCount=%d\n",ImageCount);
	Print("ImageTracking=%d\n",ImageTracking);
	Print("InputFileType=%d\n",InputFileType);
	Print("InputFilter=%d\n",InputFilter);
	Print("InputFilter_Display=%d\n",InputFilter_Display);
	Print("InputFilter_ThreshHold=%lf\n",InputFilter_ThreshHold);
	Print("InputHistoStretch=%d\n",InputHistoStretch);
	Print("InteractiveMode=%d\n",InteractiveMode);
	Print("IQuant=%d\n",IQuant);
	Print("LevelsMax=%d\n",LevelsMax);
	Print("LevelsMin=%d\n",LevelsMin);
	Print("LoadedConfig=%d\n",LoadedConfig);
	Print("MAX_STRETCH=%lf\n",MAX_STRETCH);
	Print("MaxAllowedMovement=%d\n",MaxAllowedMovement);
	Print("MergeFile=%s\n",MergeFile);
	Print("MergeThreshHold=%lf\n",MergeThreshHold);
	Print("MinPixels=%d\n",MinPixels);
	Print("MinQuality=%lf\n",MinQuality);
	Print("MkDirs=%d\n",MkDirs);
	Print("Morph_Across=%d\n",Morph_Across);
	Print("Morph_Debug=%d\n",Morph_Debug);
	Print("Morph_Down=%d\n",Morph_Down);
	Print("Morph_Drift=%d\n",Morph_Drift);
	Print("Morph_Iterations=%d\n",Morph_Iterations);
	Print("Morph_MaxTranslate=%d\n",Morph_MaxTranslate);
	Print("Morph_Min_Divisor=%d\n",Morph_Min_Divisor);
	Print("Morph_Ref=%s\n",Morph_Ref);
	Print("Morphing=%d\n",Morphing);
	Print("newHeight=%d\n",newHeight);
	Print("newWidth=%d\n",newWidth);
	Print("NoSave=%d\n",NoSave);
	Print("OutDir=%s\n",OutDir);
	Print("OutDirAppendSrc=%d\n",OutDirAppendSrc);
	Print("OutDirPrependSrc=%d\n",OutDirPrependSrc);
	Print("OutputFileDepth=%d\n",OutputFileDepth);
	Print("OutputFileType=%d\n",OutputFileType);
	Print("OutputStackFileDepth=%d\n",OutputStackFileDepth);
	Print("OverrideChannel=%d\n",OverrideChannel);
	Print("OverrideChannel_Max=%d\n",OverrideChannel_Max);
	Print("OverrideChannel_Min=%d\n",OverrideChannel_Min);
	Print("OverrideChannel_Value=%d\n",OverrideChannel_Value);
	Print("PopFilter=%d\n",PopFilter);
	Print("PopFilter_PassCount=%d\n",PopFilter_PassCount);
	Print("PopFilter_When=%d\n",PopFilter_When);
	Print("PrintFlush=%d\n",PrintFlush);
	Print("ProcessOffset=%d\n",ProcessOffset);
	Print("ProcessSkip=%d\n",ProcessSkip);
	Print("QEstimator=%d\n",QEstimator);
	Print("QF_APERTURE_RADIUS=%d\n",QF_APERTURE_RADIUS);
	Print("QHISTO_FILE=%s\n",QHISTO_FILE);
	Print("QHISTO_MAX=%d\n",QHISTO_MAX);
	Print("QHISTO_MIN=%d\n",QHISTO_MIN);
	Print("QMargin=%lf\n",QMargin);
	Print("QPR=%s\n",QPR);
	Print("QRenumberFiles=%d\n",QRenumberFiles);
	Print("QRenumberPreserveOrder=%d\n",QRenumberPreserveOrder);
	Print("QSUBSAMPLE_INC=%d\n",QSUBSAMPLE_INC);
	Print("QSUBSAMPLE_MAX=%d\n",QSUBSAMPLE_MAX);
	Print("QSUBSAMPLE_MIN=%d\n",QSUBSAMPLE_MIN);
	Print("QTrim_After=%d\n",QTrim_After);
	Print("QTrim_Before=%d\n",QTrim_Before);
	Print("QTrim_Type=%d\n",QTrim_Type);
	Print("QualityFunction=%d\n",QualityFunction);
	Print("QualityMaxCount=%d\n",QualityMaxCount);
	Print("Quiet=%d\n",Quiet);
	Print("QWriteIntermediateFiles=%d\n",QWriteIntermediateFiles);
	Print("QWriteSER=%d\n",QWriteSER);
	Print("QWriteSER_count=%d\n",QWriteSER_count);
	Print("QWriteSER_fname=%s\n",QWriteSER_fname);
	Print("RotateAngle=%lf\n",RotateAngle);
	Print("RotateCutoff=%d\n",RotateCutoff);
	Print("RowBoostAdd=%lf\n",RowBoostAdd);
	Print("RowBoostMult=%lf\n",RowBoostMult);
	Print("RowBoostType=%d\n",RowBoostType);
	Print("RowCorrection=%d\n",RowCorrection);
	Print("RunFile=%s\n",RunFile);
	Print("ShowHistogram=%d\n",ShowHistogram);
	Print("ShowMovement=%d\n",ShowMovement);
	Print("SR_X1=%d\n",SR_X1);
	Print("SR_X2=%d\n",SR_X2);
	Print("SR_Y1=%d\n",SR_Y1);
	Print("SR_Y2=%d\n",SR_Y2);
	Print("StackCount=%d\n",StackCount);
	Print("StackFile=%s\n",StackFile);
	Print("StackMax=%d\n",StackMax);
	Print("StreamFilter=%d\n",StreamFilter);
	Print("StreamFilter_History=%d\n",StreamFilter_History);
	Print("Sub_x=%d\n",Sub_x);
	Print("Sub_y=%d\n",Sub_y);
	Print("SubDirs=%d\n",SubDirs);
	Print("Subsample_max_offset=%lf\n",Subsample_max_offset);
	Print("Subsample_min_offset=%lf\n",Subsample_min_offset);
	Print("Subsample_nframes=%d\n",Subsample_nframes);
	Print("Subsample_noise=%d\n",Subsample_noise);
	Print("Subsample_pixel_height=%d\n",Subsample_pixel_height);
	Print("Subsample_pixel_width=%d\n",Subsample_pixel_width);
	Print("Subsample_prefix=%s\n",Subsample_prefix);
	Print("Subsample_scan=%d\n",Subsample_scan);
	Print("Subsample_smooth=%d\n",Subsample_smooth);
	Print("Subsample_upscale=%d\n",Subsample_upscale);
	Print("Subsample_xpixels=%d\n",Subsample_xpixels);
	Print("Subsample_ypixels=%d\n",Subsample_ypixels);
	Print("SubsampleMode=%d\n",SubsampleMode);
	Print("SumFlux=%d\n",SumFlux);
	Print("ThreshHold=%d\n",ThreshHold);
	Print("UpScale=%d\n",UpScale);
	Print("UpScale_Smoothing=%d\n",UpScale_Smoothing);
	Print("UpScale_Smoothing_When=%d\n",UpScale_Smoothing_When);
	Print("UsingStdin=%d\n",UsingStdin);
	Print("UsingStdout=%d\n",UsingStdout);
	Print("White=%d\n",White);
	Print("WriteEmptyFiles=%d\n",WriteEmptyFiles);
	Print("ZBlack=%d\n",ZBlack);
	}
