#include <stdio.h>
#include <math.h>

/*
 * Generate coefficient tables for the 1D fft
 */

/* Maximum data size = 1k (2^10) */
#define MAX_P2 10

main(int argc, char *argv[])
	{
	float c1,c2,z;
	int j,l,l1,l2;
	int dir = -1;

	if (argc>1 && !strcmp(argv[1],"rev")) dir=-1;

	c1 = -1.0;
	c2 = 0.0;
	l2 = 1;

	if (dir==1) printf("Forward\n");
	else printf("Reverse\n");

	for(l=0; l<MAX_P2; ++l) {
	   float u1 = 1.0;
	   float u2 = 0.0;

	   l1=l2;
	   l2<<=1;

printf("\n");
	   for(j=0; j<l1; ++j) {
printf("l:%d %d/%d  u1=%f u2=%f\n",l,j,l1,u1,u2);
	      	z = u1 * c1 - u2 * c2;
	      	u2 = u1 * c2 + u2 * c1;
	      	u1 = z;
	  	}

	   c2 = sqrt((1.0 - c1) / 2.0);
      	   if (dir == 1) c2 = -c2;
      	   c1 = sqrt((1.0 + c1) / 2.0);
	   }

	}
