#define _XOPEN_SOURCE 600

#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <math.h>

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif

#define V_ELEMENTS 	4	// number of elements in a vector

// Uncomment one of the following definitions
/* #define VECTORS_OF_DOUBLE 1 */
#define VECTORS_OF_SINGLE 1




#ifdef VECTORS_OF_DOUBLE
   typedef double FLOAT;
   typedef FLOAT Vec __attribute__((vector_size(32)));
#else
#if VECTORS_OF_SINGLE
   typedef float FLOAT;  // used in fft related routines
   typedef FLOAT Vec __attribute__((vector_size(16)));
#endif
#endif

#define S_FLOAT sizeof(FLOAT)
#define A_FLOAT 16              // alignment

typedef union
{
  Vec v;
  FLOAT f[V_ELEMENTS];
} f4vector;

#define FFT_FORWARD 	1
#define FFT_REVERSE 	2
#define FFT_NORMALISE 	4
#define FFT_REAL	8	// coming from real data only (imag=0)
#define FFT_NO_BRT	16	// don't do the bit reverse part of the fft

#define VFLOAT(n)  ((f4vector *)n)->v

#define LOADVC(v,c) ((v).f[0]=(v).f[1]=(v).f[2]=(v).f[3]=(c))

// This is the maximum supported matrix size (power of 2) 

#define MAX_P2 16

typedef struct
        {
        FLOAT *real;		// pointer into rptr to 16-byte aligned start
	FLOAT *imag;		// pointer into iptr to 16-byte aligned start
        int width,height;
        } COMPLEX;

// fft.c
void do_bit_reverse(FLOAT *, int);
int FFT2D(COMPLEX *c,int flags);
COMPLEX * create_complex(int width, int height);
void destroy_complex(COMPLEX *);
void * VMalloc(int bytes);
void * VRealloc(void *ptr, int bytes);
void VFree(void *ptr);
inline void _vector_zero_F(FLOAT *dst, int count);
inline void _vector_copy_F2F(FLOAT *src, FLOAT *dst, int count);
inline void _vector_multiply_Ff(FLOAT *data, float f, int count);


// transpose.c
void transpose_matrix(FLOAT *src, FLOAT *dst, int width, int height);

