#!/usr/bin/perl

my $file = shift @ARGV;

open(I,"<$file") or exit(1);
binmode(I);
my $line = <I>;
close(I);

$line =~ s/(version \d+\.\d+\.)(\d+)/sprintf("%s%d",$1,$2+1)/e;

open(O,">$file");
binmode(O);
print O $line;

# Get the build date
my @dt = localtime(time);
my $str = sprintf("%04d-%02d-%02d %02d:%02d:%02d",
	$dt[5]+1900,
	$dt[4]+1,
	$dt[3], $dt[2], $dt[1], $dt[0]
	);

printf O "#define BUILDDATE \"%s\"\n",$str;

close(O);

print $line;
