#include "ninox.h"

static int LogCount=0;

/*
 * Usage: LoadLogfile("/path","file.ser")
 *	  LoadLogfile("/path/file.ser",NULL)
 */
int
LoadLogfile(char *dir, char *n)
	{
	char fname[1024];
	char *p,line[1024];
	int i;
	FILE *z;
	char *name=NULL;

	LogCount = 0;

	// If n is NULL then assume the full path is in *dir
	if (n==NULL) {
	   if (!strcmp(dir+strlen(dir)-4,".ser")) {
		strcpy(fname,dir);
		strcpy(fname+strlen(fname)-4,".txt");
		if (isFile(fname)) goto load_file;

		strcpy(line,dir);
		strcpy(line+strlen(line)-4,".txt");
		p = line + strlen(line) - 1;
		while(p!=line && *p != '/' && *p != '\\') --p;
		if (p!=line) {
		   *p=0;
		   strcpy(fname,line);
		   strcat(fname,"/log/");
		   strcat(fname,p+1);
		   if (isFile(fname)) goto load_file;

		   strcpy(fname,line);
		   strcat(fname,"/logs/");
		   strcat(fname,p+1);
		   if (isFile(fname)) goto load_file;
		   }

		return 0;
		}
	   return 0;
	   }

	// If the archive name ends in ".ser" then change it to ".txt"
	name = Malloc(strlen(n)+4);
	Strcpy(name,n);

	p = name + strlen(name)-4;
	if (! strcasecmp(p,".ser")) Strcpy(p,".txt");
	else Strcat(name,".txt");

	// Look in the same dir as the archive
	sprintf(fname,"%s/%s",dir,name);
	Print("Look for logfile '%s'\n",fname); fflush(stdout);
	if (isFile(fname)) goto load_file;

	sprintf(fname,"%s/log/%s",dir,name);
	Print("Look for logfile '%s'\n",fname); fflush(stdout);
	if (isFile(fname)) goto load_file;

	sprintf(fname,"%s/logs/%s",dir,name);
	Print("Look for logfile '%s'\n",fname); fflush(stdout);
	if (isFile(fname)) goto load_file;

	Free(name);
	return 0;

load_file:

	LogCount=0;

	Print("LoadLogfile: Loading %s\n",fname); fflush(stdout);
	z = fopen(fname,"rb");
	while(LogCount < MAX_LOG_ENTRIES-1) {
	   line[0]=0;
	   if (! fgets(line,1023,z)) break;
	   if (! line[0]) break;

	   p = line + strlen(line)-1; while (*p=='\r' || *p=='\n') *(p--)=0;

	   // name=value pairs
	   p = strchr(line,'=');
	   if (p) {
		*p = 0;
		LogLines[LogCount].key = Strdup(line);
		LogLines[LogCount].value = Strdup(p+1);
		//Print("Loaded entry %d [%s] = [%s]\n",LogCount,LogLines[LogCount].key,LogLines[LogCount].value);
		LogCount++;
		}
	   }

	if (name) Free(name);
	fclose(z);
	Print("Loaded %d entries from %s\n",LogCount,fname);
	return 1;
	}

char *
GetLogEntry(char *str)
	{
	int i;

	for(i=0; i< LogCount; ++i) {
	   if (!strcasecmp(LogLines[i].key,str)) return LogLines[i].value;
	   }
	
	return NULL;
	}
