#include "ninox.h"

/*
 * sercat output-ser-file input-ser-file iput-ser-file ...
 *
 * appends the contents of all input files to the end of the output file
 */

// Stack Protector
#if UINT32_MAX == UINTPTR_MAX
#define STACK_CHK_GUARD 0xe2dee396
#else
#define STACK_CHK_GUARD 0x595e9fbd94fda766
#endif

uintptr_t __stack_chk_guard = STACK_CHK_GUARD;

__attribute__((noreturn))
void __stack_chk_fail(void)
{
#if __STDC_HOSTED__
        abort();
#elif __is_myos_kernel
        panic("Stack smashing detected");
#endif
}

main(int argc, char **argv)
	{
	char *of = NULL;
	FILE *ofz = NULL;
	struct Image *img;
	int i,depth,width,height;

	of = Strdup(argv[1]);
	Print("Using output file: %s\n",of); fflush(stdout);

	depth=width=height=0;

	for(i=2; i<argc; ++i) {
	   char *in = argv[i];
	   FILE *inz = OpenArchive(in);
	   int err,frcount = 0;

	   Print("Reading [%s]\n",in); fflush(stdout);
	   err=0;

	   while(1) {
	      img = ArchiveLoadNextImage_SER(inz, &err, ARCHIVE_LOAD);
	      if (err<=0) {
		Print("Finished '%s' with code %d, copied %d frames\n",in, err, frcount);
		inz = NULL;
		break;
		}

	      if (depth==0) {
		depth = img->depth;
		width = img->dst_width;
		height = img->dst_height;
		Print("Image dimensions are %d x %d x %d\n",width, height, depth); fflush(stdout);
		}

	      if (!ofz) {
		ofz = OpenSerForAppending(of,width, height, depth, "", "", "");
		if (! ofz) {
		   Print("Error: cannot open output file '%s'\n",of); fflush(stdout);
		   exit(1);
		   }
		Print("Appending to '%s'\n",of); fflush(stdout);
		}

	      // Check image
	      if (img->depth != depth || img->dst_width != width || img->dst_height != height) {
		Print("Error: Image %d (%dx%dx%d) in file %s differs from reference values %dx%dx%d\n",
			frcount,in,img->dst_width,img->dst_height,img->depth,width,height,depth);
	      	fflush(stdout);
		exit(1);
		}

	      if (! WriteSerFrame(img, ofz)) {
		Print("Error writing frame %d to %s\n",frcount, of); fflush(stdout);
		exit(1);
		}

	      ++frcount;
	      DestroyImage(img);
	      }

	   Print("Finished '%s'\n",in); fflush(stdout);
	   }

	if (ofz) CloseSerFile(ofz);
	Print("All done\n");
	exit(0);
	}
