#include <stdio.h>
#include <stdlib.h>
#include <math.h>

typedef struct
	{
	double real;
	double imag;
	} COMPLEX;

/*
 * Start with a BMP image and produce a 2D FFT output.
 * Convert the colour image in the input BMP into a luminance
 * value with L = 0.299R + 0.587R + 0.114B
 *
 * Don't forget that colour planes are stored BGR
 */

#define FALSE 0
#define TRUE 1

#define R_LUM 0.299
#define G_LUM 0.587
#define B_LUM 0.114

#define FMT_BMP 1
#define FMT_PPM 2

#define WIDTH 640
#define HEIGHT 480

#define IsBlack(R,G,B) ((R)<10 && (G)<10 && (B)<10)
#define AddColours(p,d) ((d)==24 ? *(p) + *((p)+1) + *((p)+2) : *(p) * 3)
#define AddColours24(p) (*(p) + *((p)+1) + *((p)+2))

typedef unsigned char uchar;

/*
 * Generate subsampled images between these 2 limits
 */
#define SAMPLE_MIN 2
#define SAMPLE_MAX 4

#define MAX_FILES 10000

/*
 * BMP file format header
 */

/*
 * Note that we ignore the last 5 fields 
 */

typedef struct
	{
	int filesz;	/* size of BMP file */
	short r1;	/* reserved - must be 0 */
	short r2;	/* reserved - must be 0 */
	int offset;	/* offset to image data */
	int size;	/* size of remaining header (must be 40) */
	int width;	/* image width in pixels */
	int height;	/* image height in pixels */
	short planes;	/* must be 1 */
	short bitcount;	/* bits per pixel - 1,2,4,8,16,24,32 */
	int compression;/* must be 0 for uncompressed image */
	int sizeimage;	/* image size - may be 0 for uncompressed image */
	int xppm;	/* X pixels per metre (ignore) */
	int yppm;	/* Y pixels per metre (ignore) */
	int cmapentries;/* Number of colourmap entries */
	int clrimportant; /* number of important colours */
	} bmp_header;

typedef struct
	{
	bmp_header hdr;
	unsigned char *data;
	} bmp_file;

extern int ifmt;
extern int FrameTotal;
extern int BYTES_PER_PIXEL;
extern uchar Zero[];

typedef struct {
	uchar *src;	/* Source Image */
	int src_width;	/* width of the source image in pixels */
	int src_height;	/* height of the source image in pixels */
	int x,y;	/* top left corner of image */
	int w,h;	/* width & height of this region */
	int dx,dy;	/* x & y offset */
	} Tile;

int WriteBMPHeader24(FILE *out,int width, int height);
int WriteBMPHeader(FILE *out,int width, int height, int depth, unsigned char *cmap, int entries);
int WritePPMHeader(FILE *out, int width, int height);
int WritePGMHeader8(FILE *out, int width, int height);
int WritePGMHeader16(FILE *out, int width, int height);
int ReadPPMHeader(FILE *in,char *type, int *width, int *height, int *colours);
int ReadBMPHeader(FILE *in, char *type, int *width, int *height, int *depth, unsigned char *map, int *entries);
unsigned char *LoadImage24(FILE *in, int *width, int *height);
unsigned char *LoadImage(FILE *in, int *width, int *height, int *depth, unsigned char *map, int *entries);
char * BaseName(char *);
