#include "ppmcentre.h"

int
read_fits_header(FILE *in, int *width, int *height, int *depth, double *bscale, int *bzero)
        {
        char hline[81],*arg,*val;
        int i;

        hline[80]=0;
        for(i=0; i<36; ++i) {
           if (fread(hline,80,1,in) != 1) {
                fprintf(stderr,"AlignFIT: Short read on header line %d\n",i+1);
                exit(1);
                }

           // Format is ARG = VAL
           arg=hline; while(*arg != ' ' && *arg != '=') ++arg; *arg=0;
           val = arg+1; arg=hline;

           if (!strcmp(arg,"END")) { ++i; break; }

           while(*val == ' ' || *val == '=') {
                ++val;
                }

           if (!strcmp(arg,"SIMPLE") && val[0] != 'T') {
                fprintf(stderr,"AlignFIT: Only handle SIMPLE format\n");
                exit(1);
                }

           if (!strcmp(arg,"BITPIX")) {
		*depth = atoi(val);
		if (*depth!=8 && *depth!=16) {
		   fprintf(stderr,"FITS error: depth %d not understood\n",*depth);
		   exit(1);
		   }
		}

           if (!strcmp(arg,"NAXIS") && atoi(val) != 2) {
                fprintf(stderr,"AlignFIT: Unsupported header '%s = %s'\n",arg,val);
                exit(1);
                }
           if (!strcmp(arg,"NAXIS1")) *width = atoi(val);
           if (!strcmp(arg,"NAXIS2")) *height = atoi(val);
           if (!strcmp(arg,"BSCALE")) {
		*bscale = atof(val);
		if (*bscale < 0.99 || *bscale > 2.0) {
		   fprintf(stderr,"FITS: BSCALE of %f is out of accepted range\n",*bscale);
		   exit(1);
		   }
		}

           if (!strcmp(arg,"BZERO")) {
		double v = atof(val);
		*bzero = (int)v;
		if (*bzero < 0 || *bzero > 32768) {
		   fprintf(stderr,"FITS: BZERO value of %d out of accepted range\n",*bzero);
		   exit(1);
		   }
		}
           }
        while(i++ < 36) fread(hline,80,1,in);

// hack
if (*depth==8) *bzero=0;

        return(1);
        }

int
make_fits_header(FILE *out, int w, int h, int depth, double bscale, int bzero)
	{
	static double last_bscale = -1;
	static int last_depth = -1;
	static int last_bzero = -1;
	static int last_w=-1, last_h=-1;
	static char *buffer = NULL;
	int i=0;

	if (last_bscale == bscale && last_bzero == bzero && 
		last_depth == depth && last_w == w && last_h == h 
		&& buffer)
	   goto writeout;

	if (buffer==NULL) buffer = (char *)malloc(2881);
	if (! buffer) {
	   Print("make_fits_header: out of memory\n");
	   exit(1);
	   }

	i=0;
	sprintf(buffer+i*80,"%-8.8s=%21.21s%50s","SIMPLE","T",""); ++i;
	sprintf(buffer+i*80,"%-8.8s=%21d%50s","BITPIX",depth,""); ++i;
	sprintf(buffer+i*80,"%-8.8s=%21s%50s","NAXIS","2",""); ++i;
	sprintf(buffer+i*80,"%-8.8s=%21d%50s","NAXIS1",w,""); ++i;
	sprintf(buffer+i*80,"%-8.8s=%21d%50s","NAXIS2",h,""); ++i;
	sprintf(buffer+i*80,"%-8.8s=%21d%50s","BSCALE",(int)bscale,""); ++i;
	sprintf(buffer+i*80,"%-8.8s=%21d%50s","BZERO",(int)bzero,""); ++i;
	sprintf(buffer+i*80,"%-8.8s=%21d%50s","DATAMIN",0,""); ++i;
	sprintf(buffer+i*80,"%-8.8s=%21d%50s","DATAMAX",((depth==8)?255:65535),""); ++i;
	sprintf(buffer+i*80,"%-80.80s","END",""); ++i;
	while(i<36) {sprintf(buffer+i*80,"%80s",""); ++i;}

	writeout:
	if (fwrite(buffer,2880,1,out) != 1) {
	   Print("Short write on FITS header\n");
	   exit(1);
	   }

	last_depth = depth;
	last_bzero = bzero;
	last_bscale = bscale;
	last_w = w;
	last_h = h;

	return 1;
	}

int
read_ppm_header(FILE *in,char *type, int *width, int *height, int *colours)
	{
	int ch,i,incomment;
	char buf[32];

	type[0]=0; *width=0; *height=0; *colours=0;
	incomment=0; i=0;
	while(1)
	   {
	   switch(ch=getc(in))
		{
		case EOF: return 1;
		case '#': incomment=1; break;
		case ' ': case '\t':
			if (incomment) break;
		case '\n': case '\r':
			if (incomment) {incomment=0; break;}
			if (type[0]==0)
			   {
			   strcpy(type,buf);
			   if (type[0]!='P') return 1;
			   if (type[1]!='3' && type[1]!='6') return 1;
			   i=0; buf[0]=0; break;
			   }
			if (*width==0) {*width=atoi(buf); i=0; buf[0]=0; break;}
			if (*height==0) {*height=atoi(buf); i=0; buf[0]=0; break;}
			if (*colours==0) {*colours=atoi(buf); return(0); break;}
		default:
			buf[i++]=ch; buf[i]=0; break;
	   	}
	   }
	return 1;
	}

int
read_bmp_header(FILE *in, char *type, int *width, int *height, int *depth, unsigned char *map, int *entries)
	{
	bmp_header H;
	int i;

	*type = 0;
	*width = 0;
	*height = 0;
	*entries = 0;

	if (sizeof(H) != 52) {
	   fprintf(stderr,"Struct bmp_header not 52 bytes\n");
	   exit(1);
	   }

	/* Look for magic */
	if (! fread(type,2,1,in)) {
	   fprintf(stderr,"Short read\n");
	   exit(1);
	   }

	type[2] = 0;
	if (strncmp(type,"BM",2)) {
	   fprintf(stderr,"Missing BM header - not a BMP file?\n");
	   exit(1);
	   }

	/* Read the rest of the header */
	if (! fread((char *)&H,sizeof(H),1,in)) {
	   fprintf(stderr,"Short read\n");
	   exit(1);
	   }

	/* Header remaining size shoulf be 40 bytes */
	if (H.size != 40) {
	   fprintf(stderr,"Header size %d not 40 bytes\n",H.size);
	   exit(1);
	   }

	*depth = H.bitcount;
	*entries = H.cmapentries;

	if (*depth == 24) {
	   /* Offset to image data should be 54 */
	   if (H.offset != 54) {
	      fprintf(stderr,"Image data offset %d not 54 bytes\n",H.offset);
	      exit(1);
	      }

	   /* sanity check */
	   if (H.planes == 1 && H.bitcount == 24) {
	      *width = H.width;
	      *height = H.height;
	      return 1;
	      }
	   else {
	      	fprintf(stderr,"Error in header: planes=%d, bitcount=%d\n",H.planes,H.bitcount);
		exit(1);
	      	}
	   }

	if (*depth == 8) {
	   *entries = 256;

	   /* Offset to image data should be 54  + colourmap(1024)*/
	   if (H.offset != 1024+54) {
	      fprintf(stderr,"Image data offset %d not %d bytes\n",H.offset,1024+54);
	      exit(1);
	      }

	   /* Read colourmap */
	   if (! fread(map, (*entries) * 4,1, in)) {
		fprintf(stderr,"Short read on colour map\n");
		exit(1);
	 	}

	   *width = H.width;
	   *height = H.height;

	   return 1;
	   }

	return 0;
	}
