/*
 * BMP file format header
 */

/*
 * Note that we ignore the last 5 fields 
 */

typedef struct
	{
	int filesz;	/* size of BMP file */
	short r1;	/* reserved - must be 0 */
	short r2;	/* reserved - must be 0 */
	int offset;	/* offset to image data */
	int size;	/* size of remaining header (must be 40) */
	int width;	/* image width in pixels */
	int height;	/* image height in pixels */
	short planes;	/* must be 1 */
	short bitcount;	/* bits per pixel - 1,2,4,8,16,24,32 */
	int compression;/* must be 0 for uncompressed image */
	int sizeimage;	/* image size - may be 0 for uncompressed image */
	int xppm;	/* X pixels per metre (ignore) */
	int yppm;	/* Y pixels per metre (ignore) */
	int cmapentries;/* Number of colourmap entries */
	int clrimportant; /* number of important colours */
	} bmp_header;

typedef struct
	{
	int bzero;
	double bscale;
	int datamin;
	int datamax;
	int type;	// "T" = Simple
	} fits_header;

typedef struct
	{
	bmp_header hdr;
	unsigned char *data;
	} bmp_file;

#define IMAGE_BMP_8	1
#define IMAGE_BMP_24	2
#define IMAGE_FITS_8	3
#define IMAGE_FITS_16	4

typedef struct
	{
	char *src_fname;		// name of input file
	char *dst_fname;		// name of output file
	int width;
	int height;
	int depth;
	int rowbytes;		// offset in bytes to same place in next row
	int type;		// IMAGE_*
	void *header;
	unsigned char *data;
	} Image;
