#include "ppmcentre.h"

// Command parser:
// "var" or "var=value"
int
SetVariable(char *str)
	{
	char cmdbuffer[1024],fname[1024];
	int i,j,bval;
	char *arg = cmdbuffer;
	char *val = cmdbuffer;

	/* Find the value */
	strcpy(cmdbuffer,str);
	while(*val && *val != '=') ++val;
	if (*val == '=') { 
	   *(val++) = 0;
	   while (*val==' ') ++val; 
	   }

	bval=1;
	if (!strcasecmp(val,"on") || 	!strcasecmp(val,"yes") || !strcasecmp(val,"true") ||
					!strcasecmp(val,"1"))
		bval=1;
	else if (!strcasecmp(val,"off") || 	!strcasecmp(val,"no") || !strcasecmp(val,"false") ||
						!strcasecmp(val,"0"))
		bval=0;

	if (!strcasecmp(arg,"inputfilter")) {
		if (bval==0) {InputFilter=0; return 1;}

		if (InputFilter==0 && atof(val) > 0)
		   InputFilter_ThreshHold = atof(val);
		++InputFilter;
		return 1;
		}

	if (!strcasecmp(arg,"i")) {
		InteractiveMode=bval;
		return 1;
		}

	if (!strcasecmp(arg,"enablecutout") || !strcasecmp(arg,"cutout")) {
		DoCutout=bval;
		return 1;
		}

	if (!strcasecmp(arg,"forceprocess")) {
		ForceProcess = bval;
		return 1;
		}

	if (!strcasecmp(arg,"protect")) {
		HistoProtect = bval;  // Don't prevent histo-stretching
		return 1;
		}

	if (!strcasecmp(arg,"quiet")) {
		Quiet = bval;
		return 1;
		}

	if (!strcasecmp(arg,"debayer")) {
		WantDebayer = bval;
		return 1;
		}

	if (!strcasecmp(arg,"cutx")) {
		int i = atoi(val);
		if (i < 100) {
		   Print("-cutx: minimum supported size 100 pixels\n");
		   }
		else CutX = i;
		return 1;
		}

	if (!strcasecmp(arg,"cuty")) {
		int i = atoi(val);
		if (i < 100) {
		   Print("-cutx: minimum supported size 100 pixels\n");
		   }
		else CutY = i;
		return 1;
		}

	if (!strcasecmp(arg,"cut")) {
		int i = atoi(val);
		if (i < 100 || i>480) {
		   Print("%d: Outside valid bounds 100..480\n",i);
		   return 1;
		   }
		CutX = i; CutY = i;
		newWidth = i;
		newHeight = i;
		return 1;
		}

	if (!strcasecmp(arg,"white")) {
		White = atoi(val);
		return 1;
		}

	if (!strcasecmp(arg,"smoothing")) {
		UpScale_Smoothing = bval;
		return 1;
		}

	if (!strcasecmp(arg,"upscale") || !strcasecmp(arg,"upsample") ||
		!strcasecmp(arg,"resample") || !strcasecmp(arg,"rescale")) {
		char *ptr = strstr(val,"/");
		int up=1,down=1;
		if (ptr) {
		   *ptr = 0;
		   down = atoi(ptr+1);
		   }

		up = atoi(val);
		if (up < 1 || up > 6 || down<1 || down>6) {
		   Print("UpScale: %d/%d out of accepted range (1..6)/(1..6) \n",up,down);
		   return 1;
		   }
		UpScale = up;
		DownScale = down;

		if (DownScale == 1)
		   Print("Upscaling by %d\n",UpScale);
		else
		   Print("Rescaling by %d/%d\n",UpScale,DownScale);
		return 1;
		}

	if (!strcasecmp(arg,"gamma")) {
		int g = atof(val);
		if (g < 0.3 || g > 1.5) {
		   Print("Gamma value %f is outside accepted range 0.3 <= gamma <= 1.5\n",g);
		   return 1;
		   }
		Gamma = g;
		if (Gamma != 1.0) ChangeGamma = 1;
		return 1;
		}

	if (!strcasecmp(arg,"bayerboost")) {
		BayerBoost = bval;
		return 1;
		}

	if (!strcasecmp(arg,"overwrite")) {
		AllowOverwrite = bval;
		return 1;
		}

	if (!strcasecmp(arg,"outdir")) {
		OutDir = strdup(val);
		for(j=0; OutDir[j]; ++j) if (OutDir[j]=='\\') OutDir[j]='/';
		return 1;
		}

	if (!strcasecmp(arg,"nosave")) {
		NoSave = bval;
		return 1;
		}

	if (!strcasecmp(arg,"threshhold")) {
		int t = atoi(val);
		if (t<5 || t > 250) {
		   Print("Threshhold %d out of allowed range 5..250\n",t);
		   return 1;
		   }
		ThreshHold = t;
		return 1;
		}

	if (!strcasecmp(arg,"minpixels")) {
		int m = atoi(val);
		if (m<10 || m > 1000) {
		   Print("Minpixels: %d out of alloed range 10..1000\n",m);
		   }
		else MinPixels = m;
		return 1;
		}

	if (!strcasecmp(arg,"width")) {
		int w = (int)atoi(val);
		if (w < 100 || w>640)
		   Print("Width must be 100..640\n");
		else newWidth = w;
		return 1;
		}

	if (!strcasecmp(arg,"height")) {
		int h = (int)atoi(val);
		if (h < 100 || h > 480)
		   Print("Height must be 100..480\n");
		else newHeight = h;
		return 1;
		}

	if (!strcasecmp(arg,"stack") || !strcasecmp(arg,"stackfile")) {
		StackFile = strdup(val);
		return 1;
		}

	if (!strcasecmp(arg,"stackcount")) {
		StackMax = atoi(val);
		return 1;
		}

	if (!strcasecmp(arg,"mergefile")) {
		MergeFile = strdup(val);
		return 1;
		}

	if (!strcasecmp(arg,"mergethreshhold")) {
		MergeThreshHold = atof(val);
		return 1;
		}

	if (!strcasecmp(arg,"writeemptyfiles")) {
		forceWriteEmptyFiles = bval;
		WriteEmptyFiles = bval;
		return 1;
		}

	if (!strcasecmp(arg,"qestimator")) {
		int min,max;
		QEstimator = bval;
		// Possible value "n,m" representing min and max subsampling
		if (sscanf(val,"%d,%d",&min,&max)==2) {
		   QSUBSAMPLE_MIN = min;
		   QSUBSAMPLE_MAX = max;
		   }
		return 1;
		}

	if (!strcasecmp(arg,"renumber")) {
	   	if (bval==0)
		   QRenumberFiles = 0;
		else if (!strcasecmp(val,"first")) QRenumberFiles = QRENUMBER_FIRST;
		else if (!strcasecmp(val,"last")) QRenumberFiles = QRENUMBER_LAST;
		else QRenumberFiles = QRENUMBER_FIRST; // default
		return 1;
		}

	if (!strcasecmp(arg,"qwrite")) {
		QWriteIntermediateFiles = bval;
		return 1;
		}

	if (!strcasecmp(arg,"hnoisefilter")) {
		HNoiseFilter = bval;
		return 1;
		}

	if (!strcasecmp(arg,"status")) {
		Status();
		exit(1);
		}

	if (!strcasecmp(arg,"debug")) {
		DEBUG = bval;
		return 1;
		}

	// Otherwise we don't recognise this variable
	return 0;
	}

int
Status()
	{
	int i;

	printf("Variables:\n");
	printf("Debug = %d\n",DEBUG);
	printf("CurrentFile = \"%s\"\n",CurrentFile?CurrentFile:"");

	printf("InteractiveMode = %d\n",InteractiveMode);
	printf("cutout = %d\n",DoCutout);
	printf("ForceProcess = %d\n",ForceProcess);
	printf("width = %d\n",newWidth);
	printf("height = %d\n",newHeight);
	printf("White = %d\n",White);
	printf("overwrite = %d\n",AllowOverwrite);
	printf("protect = %d\n",HistoProtect);
	printf("UpScale = %d\n",UpScale);
	printf("DownScale = %d\n",DownScale);
	printf("UpScale_Smoothing = %d\n",UpScale_Smoothing);
	printf("ThreshHold = %d\n",ThreshHold);
	printf("MinPixels = %d\n",MinPixels);
	printf("debayer = %d\n",WantDebayer);
	printf("InputFilter = %d\n",InputFilter);
	printf("InputFilter_ThreshHold = %lf\n",InputFilter_ThreshHold);
	printf("ChangeGamma = %d\n",ChangeGamma);
	printf("Gamma = %lf\n",Gamma);
	printf("CutX = %d\n",CutX);
	printf("CutY = %d\n",CutY);
	printf("BayerBoost = %lf\n",BayerBoost);
	printf("NoSave = %d\n",NoSave);
	printf("OutDir = \"%s\"\n",OutDir?OutDir:"");
	printf("WriteEmptyFiles = %d\n",WriteEmptyFiles);
	printf("Quiet = %d\n",Quiet);
	printf("StackCount = %d\n",StackCount);
	printf("StackMax = %d\n",StackMax);
	printf("StackFile = \"%s\"\n",StackFile?StackFile:"");
	printf("MergeFile = \"%s\"\n",MergeFile?MergeFile:"");
	printf("MergeThreshHold = %lf\n",MergeThreshHold);
	printf("forceWriteEmptyFiles = %d\n",forceWriteEmptyFiles);
	printf("HNoiseFilter = %d\n",HNoiseFilter);

	printf("qwrite = %d\n",QWriteIntermediateFiles);
	printf("renumber = %d\n",QRenumberFiles);
	printf("qestimator = %d\n",QEstimator);
	printf("QSUBSAMPLE_MIN = %d\n",QSUBSAMPLE_MIN);
	printf("QSUBSAMPLE_MAX = %d\n",QSUBSAMPLE_MAX);
	}

char *
ReadCommand(char *buffer, int size)
	{
	char *ptr;

	*buffer=0;
	fgets(buffer,size-1,stdin);

	// Strip off leading whitespace
	while(*buffer && *buffer <= 32) ++buffer;
	
	// Strip off trailing whitespace
	ptr = buffer + strlen(buffer);
	while(ptr != buffer && *ptr<=32) *(ptr--)=0;
	
	return buffer;
	}

int
Interact(void)
	{
	char *cmd,buffer[1024];
	Print("Interactive Mode\n");

	while(1) {
	   
	   cmd = ReadCommand(buffer,1024);
	   if (!strcasecmp(cmd,"quit") || !strcasecmp(cmd,"exit"))
		return(1);

	   if (!strncasecmp(cmd,"set ",4)) {
		SetVariable(cmd+4);
		continue;
		}

	   if (!strcasecmp(cmd,"status")) {
		Status();
		continue;
		}
	   }
	
	// notreached
	return 0;
	}
