#include "ppmcentre.h"

static double scan_area(unsigned char *,int,int,int,int,int,int);
static void scale_area(unsigned char *,int,int,int,int,int,int,double);

// Scan the image looking for a Bayer pattern in the grey values. If found then it means that
// our camera is looking through a bayer mask and we must boost the luminosity of the red and 
// blue pixels to match the green.

int DeBayer(unsigned char *buffer, int width, int height)
	{
	int sx,sy,ey,ex;
	double s1,s2,s3,s4,m;
	double f;

	/* calculate a box to scan */
	sx = 1; sy = 1;
	ex = width-2; ey = height-2;

	/* Scan diagonal area and calculate average luminosity */

	m=0;
	s1 = scan_area(buffer,width,height,sx,sy,ex,ey); if (s1>m) m=s1;
	s2 = scan_area(buffer,width,height,sx,sy+1,ex,ey+1); if (s2>m) m=s2;
	s3 = scan_area(buffer,width,height,sx+1,sy+1,ex+1,ey+1); if (s3>m) m=s3;
	s4 = scan_area(buffer,width,height,sx+1,sy,ex+1,ey); if (s4>m) m=s4;

	// printf("lum %lf %lf %lf %lf\n",s1,s2,s3,s4);

	f = BayerBoost;
	if (m-s1 > 0.1) scale_area(buffer,width,height,sx,sy,ex,ey,m/s1 * f);
	if (m-s2 > 0.1) scale_area(buffer,width,height,sx,sy+1,ex,ey+1,m/s2 * f);
	if (m-s3 > 0.1) scale_area(buffer,width,height,sx+1,sy+1,ex+1,ey+1,m/s3 * f);
	if (m-s4 > 0.1) scale_area(buffer,width,height,sx+1,sy,ex+1,ey,m/s4 * f);

	return 1;
	}

static
double scan_area(
	unsigned char *buffer, // The image data, as 24 bit RGB
	int w, int h, // width and height of image in buffer[]
	int x1, int y1, // top left corner of sample region
	int x2, int y2	// bottom right corner of sample region
	)
	{
	int lum=0;
	int count=0;
	int x,y;
	int o;

	for(y=y1; y<=y2; y+=2) {
	   o = (y * w + x1) * 3;
	   for(x=x1; x<=x2; x+=2,o+=6) {
		if (buffer[o] > ThreshHold) {
	   	   lum += buffer[o];
		   count++;
		   }
		}
	   }

	if (count==0) {
	   Print("oops - divide by zero in scan_area\n");
	   fflush(stderr); return 0;
	   }

	return (double)lum / (double) count;
	}

static void
scale_area(
	unsigned char *buffer, // The image data, as 24 bit RGB
	int w, int h, // width and height of image in buffer[]
	int x1, int y1, // top left corner of sample region
	int x2, int y2,	// bottom right corner of sample region
	double s	// scale factor
	)
	{
	int x,y;
	int o;
	double v;

	for(y=y1; y<=y2; y+=2) {
	   o = (y * w + x1) * 3;
	   for(x=x1; x<=x2; x+=2,o+=6) {
		v = buffer[o];
		v *= s;  if (v>255) v=255; if (v<0) v=0;
	   	buffer[o] = (int)v;
	   	buffer[o+1] = (int)v;
	   	buffer[o+2] = (int)v;
		}
	   }

	}
