#include "ppmcentre.h"

/*
 * Read a P6 PPM file on standard input, and write a P6 PPM file on standard output.
 * The output file will have the object centered, with the assumption that any
 * pixels with values >= 10% R/G/B are part of the object, and elsewise are background
 */

static char *VERSION = "ppmcentre 2.07a";

int
isDirectory(char *str)
	{
	struct stat st;
	int val;

	if (stat(str,&st)) {
		//fprintf(stderr,"Cannot stat '%s'\n",str);
		return(0);
		}

	val = (st.st_mode & S_IFDIR);
	return (val);
	}

int
isFile(char *str)
	{
	struct stat st;
	int val;

	if (stat(str,&st)) {
		Print("Cannot stat '%s'\n",str);
		return(0);
		}

	val = (st.st_mode & S_IFREG);
	return(val);
	}

main(int argc, char *argv[])
	{
	FILE *z;
	char fname[1024];
	int i,j;
	int FilesProcessed = 0;
	
	Print("\n%s: (C)Copyright 2005 Anthony Wesley, All Rights Reserved\n",VERSION);
	Print("This program can be freely distributed. Source code is available\n");
	Print("upon request from http://www.acquerra.com.au/astro/software/ppmcentre.\n");

	for(i=1; i < argc; ++i) {
	   char *arg = argv[i];
	   if (strstr(arg,"help") || !strcmp(arg,"-?") || !strcmp(arg,"-h") || !strcmp(arg,"/?")) {
		Usage();
		exit(0);
		}

	   if (arg[0]=='-') {
		// set VAR=VALUE
		if (SetVariable(arg+1)) continue;
		Print("%s: Unknown switch\n",arg);
		exit(1);
		}

	   if (isFile(arg)) {
		/* Must be a file to align */
	 	if (! Align(arg)) {
		   Print("Alignment failed on [%s]\n",arg);
		   exit(1);
		   }
		++FilesProcessed;
		}
	   else if (isDirectory(arg)) {
		FilesProcessed += ProcessDir(arg);
		}
	   else {
		Print("Unknown argument: '%s'\n",arg);
		exit(1);
		}
	   }
	   
	if (InteractiveMode) {
	   Interact();
	   exit(0);
	   }

	// No files specified? Then process the current directory by default
	if (FilesProcessed == 0) {
	   FilesProcessed += ProcessDir(".");
	   }

	if (! FilesProcessed) {
	   Print("Found no files to process.\n");
	   }
	else {
	   Print("\n  -> Processed %d files\n",FilesProcessed);
	   }

        if (StackCount>0 && StackFile != NULL) {
          if (!Quiet) Print("  -> Wrote stackfile %s from %d frames\n",StackFile,StackCount);
          write_stack_file(StackFile);
          }

	if (QEstimator) {
	   WriteQFile("Quality.txt");
	   if (QRenumberFiles) {
		Print("\nRenumbering...\n");
		QRenumber(QRenumberFiles);
		}
	   }

	// Save the commandline
	if (OutDir)
	   sprintf(fname,"%s/ppmcentre.run",OutDir);
	else 
	   strcpy(fname,"ppmcentre.run");

	for(i=0; fname[i]; ++i) if (fname[i]=='\\') fname[i]='/';

	z = fopen(fname,"ab");
	if (z != NULL) {
	   for(i=0; i<argc; ++i)
	      if (argv[i][0] == '-')
	      fprintf(z,"%s ",argv[i]);
	   fprintf(z,"\n");
	   fclose(z);
	   }
	else {
	   Print("Cannot save settings file %s\n",fname);
	   }

	exit(0);
	}

// Look in the named directory for files to process
int ProcessDir(char *dir)
	{
	char fname[256];
	struct dirent *e;
	DIR *d = opendir(dir);
	int i,count=0,prepend_dir;

	if (d==NULL) {
		Print("Error opening directory %s\n",dir);
		return(count);
		}

	// Munch off trailing slash
	i = strlen(dir) - 1; 
	if (dir[i] == '/' || dir[i] == '\\') dir[i] = 0;

	if (dir[0]=='.' && dir[1]==0)
	   prepend_dir = 0;
	else
	   prepend_dir = 1;

	while(e = readdir(d)) {
	   if (strlen(e->d_name)>4) {
		if (prepend_dir) sprintf(fname,"%s/%s",dir,e->d_name);
		else strcpy(fname,e->d_name);

	   	if (! access(fname,R_OK|F_OK) && (strstr(fname,".bmp") || strstr(fname,".fit"))) {
		   /* We have a xx.bmp file to align */
	 	   if (! Align(fname)) {
		   	Print("Alignment failed on [%s]\n",fname);
		 	 }
		   ++count;
		   }
		}
	   }
	closedir(d);
	return (count);
	}

// Code taken from man page for vsprintf()
int Print(char *fmt, ...)
	{
        /* Guess we need no more than 100 bytes. */
        int n, size = 100;
        char *p;
        va_list ap;
	static int start_of_line = 1;
	FILE *fd = stdout;

        if ((p = (char *)malloc (size)) == NULL) {
            fprintf(fd,"Print: Out of memory!\n");
	    fflush(fd);
	    return 0;
	    }

        while (1) {
            /* Try to print in the allocated space. */
            va_start(ap, fmt);
            n = vsnprintf (p, size, fmt, ap);
            va_end(ap);

            /* If that worked, return the string. */
            if (n > -1 && n < size) {
		for(n=0; n<size && p[n]; ++n) {
		   if (start_of_line && CurrentFile) {fprintf(fd,"%s: ",CurrentFile); fflush(fd);}
		   putc(p[n],fd);
		   if (p[n] == '\n') start_of_line = 1;
		   else start_of_line = 0;
		   }

		free(p);
		fflush(fd);
		return 1;
		}

            /* Else try again with more space. */
            if (n > -1)    /* glibc 2.1 */
               size = n+1; /* precisely what is needed */
            else           /* glibc 2.0 */
               size *= 2;  /* twice the old size */
            if ((p = realloc (p, size)) == NULL) {
		fprintf(fd,"Print: Out of memory!\n"); fflush(fd);
                return 0;
		}
             }

	// notreached
	fflush(fd);
	return 0;
        }
