#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <fcntl.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include <math.h>

#include "bmp.h"
#include "globals.h"

// Parameters for use with -renumber commandline switch
#define QRENUMBER_FIRST 1
#define QRENUMBER_LAST 2

void Usage(void);
int isDirectory(char *);
int Print(char *fmt,...);
int smooth_image(unsigned char *data,int width,int height,int bpp,int scale);
int scale_image(unsigned char *data,int width,int height, int bpp, int n);

int read_fits_header(FILE *in, int *width, int *height, int *depth, double *bscale, int *bzero);

// filetypes.c
int make_fits_header(FILE *out, int w, int h, int depth, double bscale, int bzero);
int read_bmp_header(FILE *in, char *type, int *w, int *h, int *d, unsigned char *map, int *entries);

int ProcessDir(char *dir);
int process(int *width, int *height, int depth, unsigned char *in, unsigned char *out, char *fname);
int Align(char *);
int input_filter(unsigned char *in,int width,int height,int depth,int x1, int y1, int x2, int y2);
int Clip(int w, int h, int *x1, int *y1, int *x2, int *y2);
void do_HNoiseFilter(unsigned char *buf, int w, int h, int d, int x1, int y1, int x2, int y2);

// stack.c
int stack_frame(unsigned char *data, int width, int height, int depth);
int write_stack_file(char *fname);
int merge_data(char *mfile, unsigned char *data, int width, int height, int depth);

// quality.c
void QAssociate(char *fname, double quality);
void WriteQFile(char *fname);
double QualityEstimate(unsigned char *buf, int w, int h, int d, int x1, int y1, int x2, int y2);
void Qrenumber(int);

// commands.c
int SetVariable(char *str);
int Interact(void);
